/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.apps;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.beans.ResourceResolver;
import psiprobe.controllers.AbstractContextHandlerController;
import psiprobe.model.Application;
import psiprobe.model.stats.StatsCollection;
import psiprobe.tools.ApplicationUtils;
import psiprobe.tools.SecurityUtils;

public class BaseGetApplicationController
extends AbstractContextHandlerController {
    private boolean extendedInfo;
    @Inject
    private StatsCollection statsCollection;
    private long collectionPeriod;

    public boolean isExtendedInfo() {
        return this.extendedInfo;
    }

    public void setExtendedInfo(boolean extendedInfo) {
        this.extendedInfo = extendedInfo;
    }

    public StatsCollection getStatsCollection() {
        return this.statsCollection;
    }

    public void setStatsCollection(StatsCollection statsCollection) {
        this.statsCollection = statsCollection;
    }

    public long getCollectionPeriod() {
        return this.collectionPeriod;
    }

    public void setCollectionPeriod(long collectionPeriod) {
        this.collectionPeriod = collectionPeriod;
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean calcSize = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"size", (boolean)false) && SecurityUtils.hasAttributeValueRole(this.getServletContext(), request);
        ResourceResolver resourceResolver = this.getContainerWrapper().getResourceResolver();
        Application app = ApplicationUtils.getApplication(context, this.isExtendedInfo() ? resourceResolver : null, calcSize, this.getContainerWrapper());
        if (this.isExtendedInfo() && this.getStatsCollection() != null) {
            String avgStatisticName = "app.avg_proc_time." + app.getName();
            app.setAvgTime(this.getStatsCollection().getLastValueForStat(avgStatisticName));
        }
        return new ModelAndView(this.getViewName()).addObject("app", (Object)app).addObject("no_resources", (Object)(!resourceResolver.supportsPrivateResources() ? 1 : 0)).addObject("collectionPeriod", (Object)this.getCollectionPeriod());
    }
}

