/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.apps;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.controllers.AbstractContextHandlerController;

@Controller
public class AjaxReloadContextController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(AjaxReloadContextController.class);

    @RequestMapping(path={"/app/reload.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (context != null && !request.getContextPath().equals(contextName)) {
            try {
                logger.info("{} requested RELOAD of {}", (Object)request.getRemoteAddr(), (Object)contextName);
                context.reload();
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                String name = auth.getName();
                logger.info(this.getMessageSourceAccessor().getMessage("probe.src.log.reload"), (Object)name, (Object)contextName);
            }
            catch (Exception e) {
                logger.error("Error during ajax request to RELOAD of '{}'", (Object)contextName, (Object)e);
            }
        }
        return new ModelAndView(this.getViewName(), "available", (Object)(context != null && this.getContainerWrapper().getTomcatContainer().getAvailable(context) ? 1 : 0));
    }

    @Override
    @Value(value="ajax/context_status")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

