/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers.apps;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;
import psiprobe.controllers.AbstractContextHandlerController;

public abstract class AbstractNoSelfContextHandlerController
extends AbstractContextHandlerController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNoSelfContextHandlerController.class);
    private boolean passQueryString;

    public boolean isPassQueryString() {
        return this.passQueryString;
    }

    public void setPassQueryString(boolean passQueryString) {
        this.passQueryString = passQueryString;
    }

    @Override
    protected ModelAndView handleContext(String contextName, Context context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request.getContextPath().equals(contextName)) {
                throw new IllegalStateException(this.getMessageSourceAccessor().getMessage("probe.src.contextAction.cannotActOnSelf"));
            }
            this.executeAction(contextName);
        }
        catch (Exception e) {
            request.setAttribute("errorMessage", (Object)e.getMessage());
            logger.error("Error during invocation", (Throwable)e);
            return new ModelAndView((View)new InternalResourceView(this.getViewName()));
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + this.getViewName() + (this.isPassQueryString() ? "?" + request.getQueryString() : "")));
    }

    protected abstract void executeAction(String var1) throws Exception;
}

