/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import psiprobe.tools.Whois;

@Controller
public class WhoisController
extends ParameterizableViewController {
    private static final Logger logger = LoggerFactory.getLogger(WhoisController.class);
    private long lookupTimeout;
    private String defaultServer;
    private int defaultPort;

    public long getLookupTimeout() {
        return this.lookupTimeout;
    }

    @Value(value="5")
    public void setLookupTimeout(long lookupTimeout) {
        this.lookupTimeout = lookupTimeout;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    @Value(value="whois.arin.net")
    public void setDefaultServer(String defaultServer) {
        this.defaultServer = defaultServer;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Value(value="43")
    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    @RequestMapping(path={"/whois.ajax"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean timeout = false;
        String ipAddress = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"ip", null);
        Whois.Response wh = null;
        try {
            wh = Whois.lookup(this.getDefaultServer(), this.getDefaultPort(), ipAddress, this.getLookupTimeout());
        }
        catch (IOException e) {
            timeout = true;
            logger.trace("", (Throwable)e);
        }
        ArrayList<String> lines = null;
        if (wh != null) {
            lines = new ArrayList<String>(50);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(wh.getSummary().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
        }
        String reverseName = null;
        if (ipAddress != null) {
            try {
                reverseName = InetAddress.getByName(ipAddress).getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                logger.error("could not run a DNS query on {}", (Object)ipAddress);
                logger.trace("", (Throwable)e);
            }
        }
        return new ModelAndView(this.getViewName(), "result", lines).addObject("timeout", (Object)timeout).addObject("whoisServer", (Object)(wh != null ? wh.getServer() + ":" + wh.getPort() : this.defaultServer + ":" + this.defaultPort)).addObject("domainName", (Object)reverseName);
    }

    @Value(value="ajax/whois")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

