/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import psiprobe.Utils;
import psiprobe.beans.stats.providers.SeriesProvider;
import psiprobe.jfreechart.XYLine3DRenderer;
import psiprobe.model.stats.StatsCollection;

@Controller
public class RenderChartController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(RenderChartController.class);
    @Inject
    private StatsCollection statsCollection;

    public StatsCollection getStatsCollection() {
        return this.statsCollection;
    }

    public void setStatsCollection(StatsCollection statsCollection) {
        this.statsCollection = statsCollection;
    }

    @RequestMapping(path={"/chart.png"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int seriesMaxCount = 9;
        int[] seriesColor = new int[9];
        seriesColor[0] = Utils.toIntHex(request.getParameter("s1c"), 10212091);
        seriesColor[1] = Utils.toIntHex(request.getParameter("s2c"), 0xFF0606);
        for (int i = 2; i < 9; ++i) {
            seriesColor[i] = Utils.toIntHex(request.getParameter("s" + (i + 1) + "c"), -1);
        }
        int[] seriesOutlineColor = new int[9];
        seriesOutlineColor[0] = Utils.toIntHex(request.getParameter("s1o"), 419242);
        seriesOutlineColor[1] = Utils.toIntHex(request.getParameter("s2o"), 0x9D0000);
        for (int i = 2; i < 9; ++i) {
            seriesOutlineColor[i] = Utils.toIntHex(request.getParameter("s" + (i + 1) + "o"), -1);
        }
        int backgroundColor = Utils.toIntHex(request.getParameter("bc"), 0xFFFFFF);
        int gridColor = Utils.toIntHex(request.getParameter("gc"), 0);
        String labelX = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"xl", (String)"");
        String labelY = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"yl", (String)"");
        int width = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"xz", (int)800);
        int height = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"yz", (int)400);
        boolean showLegend = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"l", (boolean)true);
        String provider = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"p", null);
        String chartType = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"ct", (String)"area");
        DefaultTableXYDataset ds = new DefaultTableXYDataset();
        if (provider != null) {
            Object series = this.getApplicationContext().getBean(provider);
            if (series instanceof SeriesProvider) {
                ((SeriesProvider)series).populate(ds, this.statsCollection, request);
            } else {
                logger.error("SeriesProvider '{}' does not implement '{}'", (Object)provider, SeriesProvider.class);
            }
        }
        JFreeChart chart = null;
        if ("area".equals(chartType)) {
            chart = ChartFactory.createXYAreaChart((String)"", (String)labelX, (String)labelY, (XYDataset)ds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
            ((XYAreaRenderer)chart.getXYPlot().getRenderer()).setOutline(true);
        } else if ("stacked".equals(chartType)) {
            chart = ChartFactory.createStackedXYAreaChart((String)"", (String)labelX, (String)labelY, (TableXYDataset)ds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
        } else if ("line".equals(chartType)) {
            chart = ChartFactory.createXYLineChart((String)"", (String)labelX, (String)labelY, (XYDataset)ds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
            XYLine3DRenderer renderer = new XYLine3DRenderer();
            renderer.setDrawOutlines(true);
            for (int i = 0; i < 9; ++i) {
                renderer.setSeriesLinesVisible(i, true);
                renderer.setSeriesShapesVisible(i, true);
                renderer.setSeriesStroke(i, new BasicStroke(2.0f));
            }
            renderer.setXOffset(1.0);
            renderer.setYOffset(1.0);
            chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
        if (chart != null) {
            chart.setAntiAlias(true);
            chart.setBackgroundPaint((Paint)new Color(backgroundColor));
            for (int i = 0; i < 9; ++i) {
                if (seriesColor[i] >= 0) {
                    chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)new Color(seriesColor[i]));
                }
                if (seriesOutlineColor[i] < 0) continue;
                chart.getXYPlot().getRenderer().setSeriesOutlinePaint(i, (Paint)new Color(seriesOutlineColor[i]));
            }
            chart.getXYPlot().setDomainGridlinePaint((Paint)new Color(gridColor));
            chart.getXYPlot().setRangeGridlinePaint((Paint)new Color(gridColor));
            chart.getXYPlot().setDomainAxis(0, (ValueAxis)new DateAxis());
            chart.getXYPlot().setDomainAxis(1, (ValueAxis)new DateAxis());
            chart.getXYPlot().setInsets(new RectangleInsets(-15.0, 0.0, 0.0, 10.0));
            response.setHeader("Content-type", "image/png");
            response.getOutputStream().write(ChartUtils.encodeAsPNG((BufferedImage)chart.createBufferedImage(width, height)));
        }
        return null;
    }
}

