/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.controllers;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import psiprobe.PostParameterizableViewController;
import psiprobe.Utils;

@Controller
public class DecoratorController
extends PostParameterizableViewController {
    private String messagesBasename;

    public String getMessagesBasename() {
        return this.messagesBasename;
    }

    @Value(value="/WEB-INF/messages")
    public void setMessagesBasename(String messagesBasename) {
        this.messagesBasename = messagesBasename;
    }

    @RequestMapping(path={"/decorator.htm"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            request.setAttribute("hostname", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            request.setAttribute("hostname", (Object)"unknown");
            this.logger.trace((Object)"", (Throwable)e);
        }
        Properties version = (Properties)this.getApplicationContext().getBean("version");
        request.setAttribute("version", (Object)version.getProperty("probe.version"));
        long uptimeStartValue = ManagementFactory.getRuntimeMXBean().getStartTime();
        long uptime = System.currentTimeMillis() - uptimeStartValue;
        long uptimeDays = uptime / 86400000L;
        long uptimeHours = (uptime %= 86400000L) / 3600000L;
        long uptimeMins = (uptime %= 3600000L) / 60000L;
        request.setAttribute("uptime_days", (Object)uptimeDays);
        request.setAttribute("uptime_hours", (Object)uptimeHours);
        request.setAttribute("uptime_mins", (Object)uptimeMins);
        String lang = "en";
        for (String fileName : this.getMessageFileNamesForLocale(request.getLocale())) {
            if (this.getServletContext().getResource(fileName + ".properties") == null) continue;
            lang = fileName.substring(this.messagesBasename.length() + 1);
            break;
        }
        request.setAttribute("lang", (Object)lang);
        return super.handleRequestInternal(request, response);
    }

    private List<String> getMessageFileNamesForLocale(Locale locale) {
        return Utils.getNamesForLocale(this.messagesBasename, locale);
    }

    @Value(value="decorators/probe")
    public void setViewName(String viewName) {
        super.setViewName(viewName);
    }
}

