/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.providers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataItem;
import org.springframework.web.bind.ServletRequestUtils;
import psiprobe.beans.stats.providers.AbstractSeriesProvider;
import psiprobe.model.stats.StatsCollection;

public class StandardSeriesProvider
extends AbstractSeriesProvider {
    private List<String> statNames = new ArrayList<String>(2);

    public List<String> getStatNames() {
        return this.statNames;
    }

    public void setStatNames(List<String> statNames) {
        this.statNames = statNames;
    }

    @Override
    public void populate(DefaultTableXYDataset dataset, StatsCollection statsCollection, HttpServletRequest request) {
        String seriesParam = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"sp", null);
        for (int i = 0; i < this.statNames.size(); ++i) {
            List<XYDataItem> stats;
            String statName = this.statNames.get(i);
            if (seriesParam != null) {
                statName = MessageFormat.format(statName, seriesParam);
            }
            if ((stats = statsCollection.getStats(statName)) == null) continue;
            String series = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)("s" + (i + 1) + "l"), (String)("series" + i));
            dataset.addSeries(this.toSeries(series, stats));
        }
    }
}

