/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.listeners;

import java.util.HashMap;
import psiprobe.Utils;
import psiprobe.beans.stats.listeners.AbstractStatsCollectionListener;
import psiprobe.beans.stats.listeners.StatsCollectionEvent;
import psiprobe.tools.SizeExpression;

public abstract class AbstractThresholdListener
extends AbstractStatsCollectionListener {
    public static final long DEFAULT_THRESHOLD = Long.MAX_VALUE;
    public static final long DEFAULT_VALUE = Long.MIN_VALUE;
    private final HashMap<String, Long> previousValues = new HashMap();
    private final HashMap<String, Boolean> seriesDisabled = new HashMap();

    protected abstract void crossedAboveThreshold(StatsCollectionEvent var1);

    protected abstract void crossedBelowThreshold(StatsCollectionEvent var1);

    protected abstract void remainedAboveThreshold(StatsCollectionEvent var1);

    protected abstract void remainedBelowThreshold(StatsCollectionEvent var1);

    @Override
    public void statsCollected(StatsCollectionEvent sce) {
        String name = sce.getName();
        if (this.isSeriesDisabled(name)) {
            return;
        }
        long value = sce.getValue();
        if (this.isValueAboveThreshold(sce)) {
            if (this.isPreviousValueAboveThreshold(sce)) {
                this.remainedAboveThreshold(sce);
            } else {
                this.crossedAboveThreshold(sce);
            }
        } else if (this.isPreviousValueAboveThreshold(sce)) {
            this.crossedBelowThreshold(sce);
        } else {
            this.remainedBelowThreshold(sce);
        }
        this.setPreviousValue(name, value);
    }

    @Override
    public void reset() {
        this.previousValues.clear();
        super.reset();
    }

    protected boolean isPreviousValueAboveThreshold(StatsCollectionEvent sce) {
        String name = sce.getName();
        long threshold = this.getThreshold(name);
        long previousValue = this.getPreviousValue(name);
        return previousValue != Long.MIN_VALUE && previousValue > threshold;
    }

    protected boolean isValueAboveThreshold(StatsCollectionEvent sce) {
        long threshold;
        String name = sce.getName();
        long value = sce.getValue();
        return value > (threshold = this.getThreshold(name));
    }

    protected long getThreshold(String name) {
        if (this.isSeriesDisabled(name)) {
            return Long.MAX_VALUE;
        }
        String threshold = this.getPropertyValue(name, "threshold");
        if (threshold == null && !this.isSeriesDisabled(name)) {
            this.logger.info("Required property '{}' is not defined or inherited.  Disabling listener for '{}' series", (Object)this.getPropertyKey(name, "threshold"), (Object)name);
            this.setSeriesDisabled(name, true);
            return Long.MAX_VALUE;
        }
        try {
            return SizeExpression.parse(threshold);
        }
        catch (NumberFormatException ex) {
            this.logger.trace("", (Throwable)ex);
            return Long.MAX_VALUE;
        }
    }

    protected long getPreviousValue(String name) {
        Long value = this.previousValues.get(name);
        return Utils.toLong(value, Long.MIN_VALUE);
    }

    protected void setPreviousValue(String name, long previousValue) {
        Long value = previousValue;
        this.previousValues.put(name, value);
    }

    protected boolean isSeriesDisabled(String name) {
        Boolean disabled = this.seriesDisabled.get(name);
        if (disabled == null) {
            disabled = Boolean.FALSE;
        }
        return disabled;
    }

    protected void setSeriesDisabled(String name, boolean disabled) {
        this.seriesDisabled.put(name, disabled);
    }
}

