/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.listeners;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.beans.stats.listeners.StatsCollectionListener;

public abstract class AbstractStatsCollectionListener
implements StatsCollectionListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String propertyCategory;
    private boolean enabled = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected String getPropertyValue(String name, String attribute) {
        String value = this.getPropertyValue(this.getPropertyKey(name, attribute));
        if (value == null) {
            value = this.getPropertyValue(this.getPropertyKey(null, attribute));
        }
        if (value == null) {
            value = this.getPropertyValue(this.getPropertyKey(null, null, attribute));
        }
        return value;
    }

    protected String getPropertyValue(String key) {
        return System.getProperty(key);
    }

    protected String getPropertyKey(String name, String attribute) {
        return this.getPropertyKey(this.getPropertyCategory(), name, attribute);
    }

    private String getPropertyKey(String category, String name, String attribute) {
        String result = this.getClass().getPackage().getName();
        if (category != null) {
            result = result + '.' + category;
        }
        if (name != null) {
            result = result + '.' + name;
        }
        if (attribute == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        result = result + '.' + attribute;
        return result;
    }

    public void reset() {
    }

    public String getPropertyCategory() {
        return this.propertyCategory;
    }

    public void setPropertyCategory(String propertyCategory) {
        this.propertyCategory = propertyCategory;
    }
}

