/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.collectors;

import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import psiprobe.beans.RuntimeInfoAccessorBean;
import psiprobe.beans.stats.collectors.AbstractStatsCollectorBean;
import psiprobe.model.jmx.RuntimeInformation;
import psiprobe.tools.TimeExpression;

public class RuntimeStatsCollectorBean
extends AbstractStatsCollectorBean {
    @Inject
    private RuntimeInfoAccessorBean runtimeInfoAccessorBean;

    public RuntimeInfoAccessorBean getRuntimeInfoAccessorBean() {
        return this.runtimeInfoAccessorBean;
    }

    public void setRuntimeInfoAccessorBean(RuntimeInfoAccessorBean runtimeInfoAccessorBean) {
        this.runtimeInfoAccessorBean = runtimeInfoAccessorBean;
    }

    @Override
    public void collect() throws Exception {
        RuntimeInformation ri = this.runtimeInfoAccessorBean.getRuntimeInformation();
        if (ri != null) {
            long time = System.currentTimeMillis();
            this.buildAbsoluteStats("os.memory.committed", ri.getCommittedVirtualMemorySize() / 1024L, time);
            this.buildAbsoluteStats("os.memory.physical", (ri.getTotalPhysicalMemorySize() - ri.getFreePhysicalMemorySize()) / 1024L, time);
            this.buildAbsoluteStats("os.memory.swap", (ri.getTotalSwapSpaceSize() - ri.getFreeSwapSpaceSize()) / 1024L, time);
            this.buildAbsoluteStats("os.fd.open", ri.getOpenFileDescriptorCount(), time);
            this.buildAbsoluteStats("os.fd.max", ri.getMaxFileDescriptorCount(), time);
            long processCpuTimeMs = ri.getProcessCpuTime() / 1000000L;
            this.buildTimePercentageStats("os.cpu", processCpuTimeMs / (long)ri.getAvailableProcessors(), time);
        }
    }

    public void setMaxSeries(@Value(value="${psiprobe.beans.stats.collectors.runtime.period}") long period, @Value(value="${psiprobe.beans.stats.collectors.runtime.span}") long span) {
        super.setMaxSeries((int)TimeExpression.dataPoints(period, span));
    }
}

