/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.collectors;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.beans.stats.collectors.AbstractStatsCollectorBean;
import psiprobe.model.ApplicationResource;
import psiprobe.model.DataSourceInfo;
import psiprobe.tools.TimeExpression;

public class DatasourceStatsCollectorBean
extends AbstractStatsCollectorBean {
    private static final String PREFIX_ESTABLISHED = "ds.est.";
    private static final String PREFIX_BUSY = "ds.busy.";
    private static final Logger logger = LoggerFactory.getLogger(DatasourceStatsCollectorBean.class);
    @Inject
    private ContainerWrapperBean containerWrapper;

    public ContainerWrapperBean getContainerWrapper() {
        return this.containerWrapper;
    }

    public void setContainerWrapper(ContainerWrapperBean containerWrapper) {
        this.containerWrapper = containerWrapper;
    }

    @Override
    public void collect() throws Exception {
        long currentTime = System.currentTimeMillis();
        if (this.containerWrapper == null) {
            logger.error("Cannot collect data source stats. Container wrapper is not set.");
        } else {
            for (ApplicationResource ds : this.getContainerWrapper().getDataSources()) {
                String appName = ds.getApplicationName();
                String name = (appName == null ? "" : appName) + '/' + ds.getName();
                DataSourceInfo dsi = ds.getDataSourceInfo();
                int numEstablished = dsi.getEstablishedConnections();
                int numBusy = dsi.getBusyConnections();
                logger.trace("Collecting stats for datasource: {}", (Object)name);
                this.buildAbsoluteStats(PREFIX_ESTABLISHED + name, numEstablished, currentTime);
                this.buildAbsoluteStats(PREFIX_BUSY + name, numBusy, currentTime);
            }
            logger.debug("datasource stats collected in {}ms", (Object)(System.currentTimeMillis() - currentTime));
        }
    }

    public void reset() throws Exception {
        if (this.containerWrapper == null) {
            logger.error("Cannot reset application stats. Container wrapper is not set.");
        } else {
            for (ApplicationResource ds : this.getContainerWrapper().getDataSources()) {
                this.reset(ds.getName());
            }
        }
    }

    public void reset(String name) throws Exception {
        this.resetStats(PREFIX_ESTABLISHED + name);
        this.resetStats(PREFIX_BUSY + name);
    }

    public void setMaxSeries(@Value(value="${psiprobe.beans.stats.collectors.datasource.period}") long period, @Value(value="${psiprobe.beans.stats.collectors.datasource.span}") long span) {
        super.setMaxSeries((int)TimeExpression.dataPoints(period, span));
    }
}

