/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.collectors;

import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import psiprobe.beans.ContainerListenerBean;
import psiprobe.beans.stats.collectors.AbstractStatsCollectorBean;
import psiprobe.model.Connector;
import psiprobe.tools.TimeExpression;

public class ConnectorStatsCollectorBean
extends AbstractStatsCollectorBean {
    @Inject
    private ContainerListenerBean listenerBean;

    public ContainerListenerBean getListenerBean() {
        return this.listenerBean;
    }

    public void setListenerBean(ContainerListenerBean listenerBean) {
        this.listenerBean = listenerBean;
    }

    @Override
    public void collect() throws Exception {
        for (Connector connector : this.listenerBean.getConnectors(false)) {
            String statName = "stat.connector." + connector.getProtocolHandler();
            this.buildDeltaStats(statName + ".requests", connector.getRequestCount());
            this.buildDeltaStats(statName + ".errors", connector.getErrorCount());
            this.buildDeltaStats(statName + ".sent", connector.getBytesSent());
            this.buildDeltaStats(statName + ".received", connector.getBytesReceived());
            this.buildDeltaStats(statName + ".proc_time", connector.getProcessingTime());
        }
    }

    public void reset() throws Exception {
        for (Connector connector : this.listenerBean.getConnectors(false)) {
            this.reset(connector.getProtocolHandler());
        }
    }

    public void reset(String connectorName) {
        String statName = "stat.connector." + connectorName;
        this.resetStats(statName + ".requests");
        this.resetStats(statName + ".errors");
        this.resetStats(statName + ".sent");
        this.resetStats(statName + ".received");
        this.resetStats(statName + ".proc_time");
    }

    public void setMaxSeries(@Value(value="${psiprobe.beans.stats.collectors.connector.period}") long period, @Value(value="${psiprobe.beans.stats.collectors.connector.span}") long span) {
        super.setMaxSeries((int)TimeExpression.dataPoints(period, span));
    }
}

