/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.collectors;

import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import psiprobe.TomcatContainer;
import psiprobe.beans.ClusterWrapperBean;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.beans.stats.collectors.AbstractStatsCollectorBean;
import psiprobe.model.jmx.Cluster;
import psiprobe.tools.TimeExpression;

public class ClusterStatsCollectorBean
extends AbstractStatsCollectorBean {
    @Inject
    private ContainerWrapperBean containerWrapper;
    @Inject
    private ClusterWrapperBean clusterWrapper;

    public ContainerWrapperBean getContainerWrapper() {
        return this.containerWrapper;
    }

    public void setContainerWrapper(ContainerWrapperBean containerWrapper) {
        this.containerWrapper = containerWrapper;
    }

    public ClusterWrapperBean getClusterWrapper() {
        return this.clusterWrapper;
    }

    public void setClusterWrapper(ClusterWrapperBean clusterWrapper) {
        this.clusterWrapper = clusterWrapper;
    }

    @Override
    public void collect() throws Exception {
        Cluster cluster;
        TomcatContainer container = this.containerWrapper.getTomcatContainer();
        if (container != null && (cluster = this.clusterWrapper.getCluster(container.getName(), container.getHostName(), false)) != null) {
            this.buildDeltaStats("cluster.received", cluster.getTotalReceivedBytes());
            this.buildDeltaStats("cluster.sent", cluster.getSenderTotalBytes());
            this.buildDeltaStats("cluster.req.received", cluster.getNrOfMsgsReceived());
            this.buildDeltaStats("cluster.req.sent", cluster.getSenderNrOfRequests());
        }
    }

    public void setMaxSeries(@Value(value="${psiprobe.beans.stats.collectors.cluster.period}") long period, @Value(value="${psiprobe.beans.stats.collectors.cluster.span}") long span) {
        super.setMaxSeries((int)TimeExpression.dataPoints(period, span));
    }
}

