/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.collectors;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.ServletContextAware;
import psiprobe.TomcatContainer;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.beans.stats.collectors.AbstractStatsCollectorBean;
import psiprobe.model.Application;
import psiprobe.tools.ApplicationUtils;
import psiprobe.tools.TimeExpression;

public class AppStatsCollectorBean
extends AbstractStatsCollectorBean
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(AppStatsCollectorBean.class);
    @Inject
    private ContainerWrapperBean containerWrapper;
    @Inject
    private ServletContext servletContext;
    private boolean selfIgnored;

    public ContainerWrapperBean getContainerWrapper() {
        return this.containerWrapper;
    }

    public void setContainerWrapper(ContainerWrapperBean containerWrapper) {
        this.containerWrapper = containerWrapper;
    }

    public boolean isSelfIgnored() {
        return this.selfIgnored;
    }

    @Value(value="${psiprobe.beans.stats.collectors.app.selfIgnored}")
    public void setSelfIgnored(boolean selfIgnored) {
        this.selfIgnored = selfIgnored;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void collect() throws Exception {
        long currentTime = System.currentTimeMillis();
        if (this.containerWrapper == null) {
            logger.error("Cannot collect application stats. Container wrapper is not set.");
        } else {
            TomcatContainer tomcatContainer = this.getContainerWrapper().getTomcatContainer();
            if (tomcatContainer != null) {
                long totalReqDelta = 0L;
                long totalErrDelta = 0L;
                long totalAvgProcTime = 0L;
                int participatingAppCount = 0;
                for (Context ctx : tomcatContainer.findContexts()) {
                    if (ctx == null || ctx.getName() == null) continue;
                    Application app = new Application();
                    ApplicationUtils.collectApplicationServletStats(ctx, app);
                    String appName = "".equals(ctx.getName()) ? "/" : ctx.getName();
                    long reqDelta = this.buildDeltaStats("app.requests." + appName, app.getRequestCount(), currentTime);
                    long errDelta = this.buildDeltaStats("app.errors." + appName, app.getErrorCount());
                    long procTimeDelta = this.buildDeltaStats("app.proc_time." + appName, app.getProcessingTime(), currentTime);
                    long avgProcTime = reqDelta == 0L ? 0L : procTimeDelta / reqDelta;
                    this.buildAbsoluteStats("app.avg_proc_time." + appName, avgProcTime, currentTime);
                    if (reqDelta <= 0L || this.excludeFromTotal(ctx)) continue;
                    totalReqDelta += reqDelta;
                    totalErrDelta += errDelta;
                    totalAvgProcTime += avgProcTime;
                    ++participatingAppCount;
                }
                this.buildAbsoluteStats("total.requests", totalReqDelta, currentTime);
                this.buildAbsoluteStats("total.errors", totalErrDelta, currentTime);
                this.buildAbsoluteStats("total.avg_proc_time", participatingAppCount == 0 ? 0L : totalAvgProcTime / (long)participatingAppCount, currentTime);
            }
            logger.debug("app stats collected in {}ms", (Object)(System.currentTimeMillis() - currentTime));
        }
    }

    private boolean excludeFromTotal(Context ctx) {
        return this.isSelfIgnored() && this.getServletContext().equals(ctx.getServletContext());
    }

    public void reset() {
        if (this.containerWrapper == null) {
            logger.error("Cannot reset application stats. Container wrapper is not set.");
        } else {
            TomcatContainer tomcatContainer = this.getContainerWrapper().getTomcatContainer();
            if (tomcatContainer != null) {
                for (Context ctx : tomcatContainer.findContexts()) {
                    if (ctx == null || ctx.getName() == null) continue;
                    String appName = "".equals(ctx.getName()) ? "/" : ctx.getName();
                    this.reset(appName);
                }
            }
        }
        this.resetStats("total.requests");
        this.resetStats("total.errors");
        this.resetStats("total.avg_proc_time");
    }

    public void reset(String appName) {
        this.resetStats("app.requests." + appName);
        this.resetStats("app.proc_time." + appName);
        this.resetStats("app.errors." + appName);
        this.resetStats("app.avg_proc_time." + appName);
    }

    public void setMaxSeries(@Value(value="${psiprobe.beans.stats.collectors.app.period}") long period, @Value(value="${psiprobe.beans.stats.collectors.app.span}") long span) {
        super.setMaxSeries((int)TimeExpression.dataPoints(period, span));
    }
}

