/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.stats.collectors;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.jfree.data.xy.XYDataItem;
import psiprobe.Utils;
import psiprobe.beans.stats.listeners.StatsCollectionEvent;
import psiprobe.beans.stats.listeners.StatsCollectionListener;
import psiprobe.model.stats.StatsCollection;

public abstract class AbstractStatsCollectorBean {
    @Inject
    private StatsCollection statsCollection;
    private int maxSeries = 240;
    private List<StatsCollectionListener> listeners;
    private final Map<String, Long> previousData = new TreeMap<String, Long>();
    private final Map<String, Entry> previousData2D = new TreeMap<String, Entry>();

    public StatsCollection getStatsCollection() {
        return this.statsCollection;
    }

    public void setStatsCollection(StatsCollection statsCollection) {
        this.statsCollection = statsCollection;
    }

    public int getMaxSeries() {
        return this.maxSeries;
    }

    public void setMaxSeries(int maxSeries) {
        this.maxSeries = maxSeries;
    }

    public List<StatsCollectionListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<StatsCollectionListener> listeners) {
        this.listeners = listeners;
    }

    public abstract void collect() throws Exception;

    protected long buildDeltaStats(String name, long value) throws InterruptedException {
        return this.buildDeltaStats(name, value, System.currentTimeMillis());
    }

    protected long buildDeltaStats(String name, long value, long time) throws InterruptedException {
        long delta = 0L;
        if (this.statsCollection != null) {
            long previousValue = Utils.toLong(this.previousData.get(name), 0L);
            delta = value - previousValue;
            delta = delta > 0L ? delta : 0L;
            this.buildAbsoluteStats(name, delta, time);
            this.previousData.put(name, value);
        }
        return delta;
    }

    protected void buildAbsoluteStats(String name, long value) throws InterruptedException {
        this.buildAbsoluteStats(name, value, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildAbsoluteStats(String name, long value, long time) throws InterruptedException {
        List<XYDataItem> stats = this.statsCollection.getStats(name);
        if (stats == null) {
            this.statsCollection.newStats(name, this.maxSeries);
        } else {
            XYDataItem data = new XYDataItem((double)time, (double)value);
            this.statsCollection.lockForUpdate();
            try {
                stats.add(data);
                this.houseKeepStats(stats);
            }
            finally {
                this.statsCollection.releaseLock();
            }
            if (this.listeners != null) {
                StatsCollectionEvent event = new StatsCollectionEvent(name, data);
                for (StatsCollectionListener listener : this.listeners) {
                    if (!listener.isEnabled()) continue;
                    listener.statsCollected(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildTimePercentageStats(String name, long value, long time) throws InterruptedException {
        Entry entry = this.previousData2D.get(name);
        if (entry == null) {
            entry = new Entry();
            entry.value = value;
            entry.time = time;
            this.previousData2D.put(name, entry);
        } else {
            double valueDelta = (double)value - (double)entry.value;
            double timeDelta = (double)time - (double)entry.time;
            double statValue = valueDelta * 100.0 / timeDelta;
            this.statsCollection.lockForUpdate();
            try {
                List<XYDataItem> stats = this.statsCollection.getStats(name);
                if (stats == null) {
                    stats = this.statsCollection.newStats(name, this.maxSeries);
                }
                stats.add(stats.size(), new XYDataItem((double)time, statValue));
                this.houseKeepStats(stats);
            }
            finally {
                this.statsCollection.releaseLock();
            }
        }
    }

    protected void resetStats(String name) {
        this.statsCollection.resetStats(name);
    }

    private void houseKeepStats(List<XYDataItem> stats) {
        while (stats.size() > this.maxSeries) {
            stats.remove(0);
        }
    }

    private static class Entry {
        long time;
        long value;
    }
}

