/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import java.lang.management.ManagementFactory;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.ViburMonitoringMBean;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class ViburCpDatasourceAccessor
implements DatasourceAccessor {
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            ViburDBCPDataSource source = (ViburDBCPDataSource)resource;
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolName = new ObjectName(source.getJmxName());
            ViburMonitoringMBean poolProxy = JMX.newMXBeanProxy(mbeanServer, poolName, ViburMonitoringMBean.class);
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setBusyConnections(poolProxy.getPoolTaken());
            dataSourceInfo.setEstablishedConnections(poolProxy.getPoolRemainingCreated() + poolProxy.getPoolTaken());
            dataSourceInfo.setMaxConnections(source.getPoolMaxSize());
            dataSourceInfo.setJdbcUrl(source.getJdbcUrl());
            dataSourceInfo.setUsername(source.getUsername());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("vibur");
        }
        return dataSourceInfo;
    }

    public boolean reset(Object resource) throws Exception {
        return false;
    }

    public boolean canMap(Object resource) {
        return "org.vibur.dbcp.ViburDBCPDataSource".equals(resource.getClass().getName()) && resource instanceof ViburDBCPDataSource;
    }
}

