/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import org.apache.commons.dbcp2.BasicDataSource;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class OpenEjbBasicDatasourceAccessor
implements DatasourceAccessor {
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            BasicDataSource source = (BasicDataSource)resource;
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setBusyConnections(source.getNumActive());
            dataSourceInfo.setEstablishedConnections(source.getNumIdle() + source.getNumActive());
            dataSourceInfo.setMaxConnections(source.getMaxTotal());
            dataSourceInfo.setJdbcUrl(source.getUrl());
            dataSourceInfo.setUsername(source.getUsername());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("commons-dbcp2");
        }
        return dataSourceInfo;
    }

    public boolean reset(Object resource) throws Exception {
        return false;
    }

    public boolean canMap(Object resource) {
        return "org.apache.openejb.resource.jdbc.dbcp.BasicDataSource".equals(resource.getClass().getName()) && resource instanceof BasicDataSource;
    }
}

