/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPDataSource;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class BoneCpDatasourceAccessor
implements DatasourceAccessor {
    private static final Logger logger = LoggerFactory.getLogger(BoneCpDatasourceAccessor.class);

    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            BoneCP pool;
            BoneCPDataSource source = (BoneCPDataSource)resource;
            try {
                pool = source.getPool();
            }
            catch (NoSuchMethodError ex) {
                logger.trace("", (Throwable)ex);
                Field poolField = BoneCPDataSource.class.getDeclaredField("pool");
                poolField.setAccessible(true);
                pool = (BoneCP)poolField.get(source);
            }
            dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setBusyConnections(source.getTotalLeased());
            if (pool == null) {
                dataSourceInfo.setEstablishedConnections(source.getMinConnectionsPerPartition());
                logger.warn("pool is null {}", (Object)source.getJdbcUrl());
            } else {
                dataSourceInfo.setEstablishedConnections(pool.getTotalCreatedConnections());
            }
            dataSourceInfo.setMaxConnections(source.getPartitionCount() * source.getMaxConnectionsPerPartition());
            dataSourceInfo.setJdbcUrl(source.getJdbcUrl());
            dataSourceInfo.setUsername(source.getUsername());
            dataSourceInfo.setResettable(false);
            dataSourceInfo.setType("bonecp");
        }
        return dataSourceInfo;
    }

    public boolean reset(Object resource) throws Exception {
        return false;
    }

    public boolean canMap(Object resource) {
        return "com.jolbox.bonecp.BoneCPDataSource".equals(resource.getClass().getName()) && resource instanceof BoneCPDataSource;
    }
}

