/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Context;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.beans.ResourceResolver;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.ApplicationResource;
import psiprobe.model.DataSourceInfo;

public class ResourceResolverBean
implements ResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolverBean.class);
    public static final String DEFAULT_GLOBAL_RESOURCE_PREFIX = "";
    public static final String DEFAULT_RESOURCE_PREFIX = "java:comp/env/";
    @Inject
    private List<String> datasourceMappers;

    @Override
    public List<ApplicationResource> getApplicationResources() throws NamingException {
        logger.debug("Reading GLOBAL resources");
        ArrayList<ApplicationResource> resources = new ArrayList<ApplicationResource>();
        MBeanServer server = this.getMBeanServer();
        if (server != null) {
            try {
                Set<ObjectName> dsNames = server.queryNames(new ObjectName("Catalina:type=Resource,resourcetype=Global,*"), null);
                for (ObjectName objectName : dsNames) {
                    ApplicationResource resource = new ApplicationResource();
                    logger.debug("reading resource: {}", (Object)objectName);
                    resource.setName(this.getStringAttribute(server, objectName, "name"));
                    resource.setType(this.getStringAttribute(server, objectName, "type"));
                    resource.setScope(this.getStringAttribute(server, objectName, "scope"));
                    resource.setAuth(this.getStringAttribute(server, objectName, "auth"));
                    resource.setDescription(this.getStringAttribute(server, objectName, "description"));
                    this.lookupResource(resource, true, true);
                    resources.add(resource);
                }
            }
            catch (Exception e) {
                logger.error("There was an error querying JMX server:", (Throwable)e);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<ApplicationResource> getApplicationResources(Context context, ContainerWrapperBean containerWrapper) throws NamingException {
        ArrayList<ApplicationResource> resourceList = new ArrayList<ApplicationResource>();
        boolean contextAvailable = containerWrapper.getTomcatContainer().getAvailable(context);
        if (contextAvailable) {
            logger.debug("Reading CONTEXT {}", (Object)context.getName());
            boolean contextBound = false;
            try {
                containerWrapper.getTomcatContainer().bindToContext(context);
                contextBound = true;
            }
            catch (NamingException e) {
                logger.error("Cannot bind to context. useNaming=false ?");
                logger.debug(DEFAULT_GLOBAL_RESOURCE_PREFIX, (Throwable)e);
            }
            try {
                containerWrapper.getTomcatContainer().addContextResource(context, resourceList, contextBound);
                containerWrapper.getTomcatContainer().addContextResourceLink(context, resourceList, contextBound);
                for (ApplicationResource resourceList1 : resourceList) {
                    this.lookupResource(resourceList1, contextBound, false);
                }
            }
            finally {
                if (contextBound) {
                    containerWrapper.getTomcatContainer().unbindFromContext(context);
                }
            }
        }
        return resourceList;
    }

    public void lookupResource(ApplicationResource resource, boolean contextBound, boolean global) {
        DataSourceInfo dataSourceInfo = null;
        if (contextBound) {
            try {
                javax.naming.Context ctx;
                javax.naming.Context context = ctx = !global ? new InitialContext() : ResourceResolverBean.getGlobalNamingContext();
                if (ctx == null) {
                    logger.error("Unable to find context. This may indicate invalid setup. Check global resources versus requested resources");
                    resource.setLookedUp(false);
                    return;
                }
                String jndiName = ResourceResolverBean.resolveJndiName(resource.getName(), global);
                logger.debug("reading resource jndi name: {}", (Object)jndiName);
                Object obj = ctx.lookup(jndiName);
                resource.setLookedUp(true);
                for (String accessorString : this.datasourceMappers) {
                    logger.debug("Looking up datasource adapter: {}", (Object)accessorString);
                    DatasourceAccessor accessor = (DatasourceAccessor)Class.forName(accessorString).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    dataSourceInfo = accessor.getInfo(obj);
                    if (dataSourceInfo == null) continue;
                }
            }
            catch (Exception e) {
                resource.setLookedUp(false);
                dataSourceInfo = null;
                logger.error("Failed to lookup: '{}'", (Object)resource.getName(), (Object)e);
            }
        } else {
            resource.setLookedUp(false);
        }
        if (resource.isLookedUp() && dataSourceInfo != null) {
            resource.setDataSourceInfo(dataSourceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean resetResource(Context context, String resourceName, ContainerWrapperBean containerWrapper) throws NamingException {
        if (context != null) {
            containerWrapper.getTomcatContainer().bindToContext(context);
        }
        try {
            javax.naming.Context ctx = context != null ? new InitialContext() : ResourceResolverBean.getGlobalNamingContext();
            String jndiName = ResourceResolverBean.resolveJndiName(resourceName, context == null);
            Object obj = ctx.lookup(jndiName);
            try {
                for (String accessorString : this.datasourceMappers) {
                    logger.debug("Resetting datasource adapter: {}", (Object)accessorString);
                    DatasourceAccessor accessor = (DatasourceAccessor)Class.forName(accessorString).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!accessor.reset(obj)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                logger.trace(DEFAULT_GLOBAL_RESOURCE_PREFIX, (Throwable)e);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (context != null) {
                containerWrapper.getTomcatContainer().unbindFromContext(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DataSource lookupDataSource(Context context, String resourceName, ContainerWrapperBean containerWrapper) throws NamingException {
        if (context != null) {
            containerWrapper.getTomcatContainer().bindToContext(context);
        }
        try {
            javax.naming.Context ctx = context != null ? new InitialContext() : ResourceResolverBean.getGlobalNamingContext();
            String jndiName = ResourceResolverBean.resolveJndiName(resourceName, context == null);
            Object obj = ctx.lookup(jndiName);
            if (obj instanceof DataSource) {
                DataSource dataSource = (DataSource)obj;
                return dataSource;
            }
            DataSource dataSource = null;
            return dataSource;
        }
        finally {
            if (context != null) {
                containerWrapper.getTomcatContainer().unbindFromContext(context);
            }
        }
    }

    public List<String> getDatasourceMappers() {
        return this.datasourceMappers;
    }

    public void setDatasourceMappers(List<String> datasourceMappers) {
        this.datasourceMappers = datasourceMappers;
    }

    @Override
    public boolean supportsPrivateResources() {
        return true;
    }

    @Override
    public boolean supportsGlobalResources() {
        return true;
    }

    @Override
    public boolean supportsDataSourceLookup() {
        return true;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected static String resolveJndiName(String name, boolean global) {
        return (global ? DEFAULT_GLOBAL_RESOURCE_PREFIX : DEFAULT_RESOURCE_PREFIX) + name;
    }

    private String getStringAttribute(MBeanServer server, ObjectName objectName, String attributeName) {
        try {
            return (String)server.getAttribute(objectName, attributeName);
        }
        catch (Exception e) {
            logger.error("Error getting attribute '{}' from '{}'", new Object[]{attributeName, objectName, e});
            return null;
        }
    }

    public static javax.naming.Context getGlobalNamingContext() {
        javax.naming.Context globalContext = null;
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mbeanServer != null) {
            for (String domain : mbeanServer.getDomains()) {
                ObjectName name;
                try {
                    name = new ObjectName(domain + ":type=Server");
                }
                catch (MalformedObjectNameException e) {
                    logger.error(DEFAULT_GLOBAL_RESOURCE_PREFIX, (Throwable)e);
                    return null;
                }
                Server server = null;
                try {
                    server = (Server)mbeanServer.getAttribute(name, "managedResource");
                }
                catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                    logger.trace("JMX objectName {} does not contain any managedResource", (Object)name, (Object)e);
                }
                if (server == null || !(server instanceof StandardServer)) continue;
                globalContext = server.getGlobalNamingContext();
                break;
            }
        }
        return globalContext;
    }
}

