/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans;

import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.model.jmx.MemoryPool;
import psiprobe.tools.JmxTools;

public class JvmMemoryInfoAccessorBean {
    private static final Logger logger = LoggerFactory.getLogger(JvmMemoryInfoAccessorBean.class);

    public List<MemoryPool> getPools() throws Exception {
        LinkedList<MemoryPool> memoryPools = new LinkedList<MemoryPool>();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> memoryOPools = mbeanServer.queryMBeans(new ObjectName("java.lang:type=MemoryPool,*"), null);
        long totalInit = 0L;
        long totalMax = 0L;
        long totalUsed = 0L;
        long totalCommitted = 0L;
        for (ObjectInstance oi : memoryOPools) {
            ObjectName objName = oi.getObjectName();
            MemoryPool memoryPool = new MemoryPool();
            memoryPool.setName(JmxTools.getStringAttr(mbeanServer, objName, "Name"));
            memoryPool.setType(JmxTools.getStringAttr(mbeanServer, objName, "Type"));
            CompositeDataSupport cd = (CompositeDataSupport)mbeanServer.getAttribute(objName, "Usage");
            if (cd != null) {
                memoryPool.setMax(JmxTools.getLongAttr(cd, "max"));
                memoryPool.setUsed(JmxTools.getLongAttr(cd, "used"));
                memoryPool.setInit(JmxTools.getLongAttr(cd, "init"));
                memoryPool.setCommitted(JmxTools.getLongAttr(cd, "committed"));
            } else {
                logger.error("Oops, JVM problem? {} 'Usage' attribute is NULL!", (Object)objName);
            }
            totalInit += memoryPool.getInit();
            totalMax += memoryPool.getMax();
            totalUsed += memoryPool.getUsed();
            totalCommitted += memoryPool.getCommitted();
            memoryPools.add(memoryPool);
        }
        if (!memoryPools.isEmpty()) {
            MemoryPool pool = new MemoryPool();
            pool.setName("Total");
            pool.setType("TOTAL");
            pool.setInit(totalInit);
            pool.setUsed(totalUsed);
            pool.setMax(totalMax);
            pool.setCommitted(totalCommitted);
            memoryPools.add(pool);
        }
        return memoryPools;
    }
}

