/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans;

import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.Country;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psiprobe.beans.ContainerWrapperBean;
import psiprobe.model.Connector;
import psiprobe.model.RequestProcessor;
import psiprobe.model.ThreadPool;
import psiprobe.model.jmx.ThreadPoolObjectName;
import psiprobe.tools.JmxTools;

public class ContainerListenerBean
implements NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(ContainerListenerBean.class);
    private Set<String> allowedOperation = new HashSet<String>(Arrays.asList("start", "stop", "pause", "resume"));
    private List<ThreadPoolObjectName> poolNames;
    private List<ObjectName> executorNames;
    @Inject
    private ContainerWrapperBean containerWrapper;

    public ContainerWrapperBean getContainerWrapper() {
        return this.containerWrapper;
    }

    public void setContainerWrapper(ContainerWrapperBean containerWrapper) {
        this.containerWrapper = containerWrapper;
    }

    private boolean isInitialized() {
        return this.poolNames != null && !this.poolNames.isEmpty();
    }

    private ThreadPoolObjectName findPool(String name) {
        if (name != null && this.isInitialized()) {
            for (ThreadPoolObjectName threadPoolObjectName : this.poolNames) {
                if (!name.equals(threadPoolObjectName.getThreadPoolName().getKeyProperty("name"))) continue;
                return threadPoolObjectName;
            }
        }
        return null;
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object object) {
        ThreadPoolObjectName threadPoolObjectName;
        ObjectName objectName;
        if ((notification instanceof MBeanServerNotification && "JMX.mbean.registered".equals(notification.getType()) || "JMX.mbean.unregistered".equals(notification.getType())) && "RequestProcessor".equals((objectName = ((MBeanServerNotification)notification).getMBeanName()).getKeyProperty("type")) && (threadPoolObjectName = this.findPool(objectName.getKeyProperty("worker"))) != null) {
            if ("JMX.mbean.registered".equals(notification.getType())) {
                threadPoolObjectName.getRequestProcessorNames().add(objectName);
            } else {
                threadPoolObjectName.getRequestProcessorNames().remove(objectName);
            }
        }
    }

    private synchronized void initialize() throws Exception {
        MBeanServer server = this.getContainerWrapper().getResourceResolver().getMBeanServer();
        String serverName = this.getContainerWrapper().getTomcatContainer().getName();
        Set<ObjectInstance> threadPools = server.queryMBeans(new ObjectName(serverName + ":type=ThreadPool,name=\"*\""), null);
        this.poolNames = new ArrayList<ThreadPoolObjectName>(threadPools.size());
        for (ObjectInstance threadPool : threadPools) {
            ThreadPoolObjectName threadPoolObjectName = new ThreadPoolObjectName();
            ObjectName threadPoolName = threadPool.getObjectName();
            String name = threadPoolName.getKeyProperty("name");
            threadPoolObjectName.setThreadPoolName(threadPoolName);
            ObjectName grpName = server.getObjectInstance(new ObjectName(threadPoolName.getDomain() + ":type=GlobalRequestProcessor,name=" + name)).getObjectName();
            threadPoolObjectName.setGlobalRequestProcessorName(grpName);
            Set<ObjectInstance> workers = server.queryMBeans(new ObjectName(threadPoolName.getDomain() + ":type=RequestProcessor,*"), null);
            for (ObjectInstance worker : workers) {
                ObjectName wrkName = worker.getObjectName();
                if (!name.equals(wrkName.getKeyProperty("worker"))) continue;
                threadPoolObjectName.getRequestProcessorNames().add(wrkName);
            }
            this.poolNames.add(threadPoolObjectName);
        }
        Set<ObjectInstance> executors = server.queryMBeans(new ObjectName(serverName + ":type=Executor,*"), null);
        this.executorNames = new ArrayList<ObjectName>(executors.size());
        for (ObjectInstance executor : executors) {
            ObjectName executorName = executor.getObjectName();
            this.executorNames.add(executorName);
        }
        server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
    }

    public synchronized List<ThreadPool> getThreadPools() throws Exception {
        if (!this.isInitialized()) {
            this.initialize();
        }
        ArrayList<ThreadPool> threadPools = new ArrayList<ThreadPool>(this.poolNames.size());
        MBeanServer server = this.getContainerWrapper().getResourceResolver().getMBeanServer();
        for (ObjectName executorName : this.executorNames) {
            ThreadPool threadPool = new ThreadPool();
            threadPool.setName(executorName.getKeyProperty("name"));
            threadPool.setMaxThreads(JmxTools.getIntAttr(server, executorName, "maxThreads"));
            threadPool.setMaxSpareThreads(JmxTools.getIntAttr(server, executorName, "largestPoolSize"));
            threadPool.setMinSpareThreads(JmxTools.getIntAttr(server, executorName, "minSpareThreads"));
            threadPool.setCurrentThreadsBusy(JmxTools.getIntAttr(server, executorName, "activeCount"));
            threadPool.setCurrentThreadCount(JmxTools.getIntAttr(server, executorName, "poolSize"));
            threadPools.add(threadPool);
        }
        for (ThreadPoolObjectName threadPoolObjectName : this.poolNames) {
            try {
                ObjectName poolName = threadPoolObjectName.getThreadPoolName();
                ThreadPool threadPool = new ThreadPool();
                threadPool.setName(poolName.getKeyProperty("name"));
                threadPool.setMaxThreads(JmxTools.getIntAttr(server, poolName, "maxThreads"));
                if (JmxTools.hasAttribute(server, poolName, "maxSpareThreads")) {
                    threadPool.setMaxSpareThreads(JmxTools.getIntAttr(server, poolName, "maxSpareThreads"));
                    threadPool.setMinSpareThreads(JmxTools.getIntAttr(server, poolName, "minSpareThreads"));
                }
                threadPool.setCurrentThreadsBusy(JmxTools.getIntAttr(server, poolName, "currentThreadsBusy"));
                threadPool.setCurrentThreadCount(JmxTools.getIntAttr(server, poolName, "currentThreadCount"));
                if (threadPool.getMaxThreads() <= -1) continue;
                threadPools.add(threadPool);
            }
            catch (InstanceNotFoundException e) {
                logger.error("Failed to query entire thread pool {}", (Object)threadPoolObjectName);
                logger.debug("", (Throwable)e);
            }
        }
        return threadPools;
    }

    public synchronized void toggleConnectorStatus(String operation, String port) throws Exception {
        if (!this.allowedOperation.contains(operation)) {
            logger.error("operation {} not supported", (Object)operation);
            throw new IllegalArgumentException("Not support operation");
        }
        ObjectName objectName = new ObjectName("Catalina:type=Connector,port=" + port);
        MBeanServer server = this.getContainerWrapper().getResourceResolver().getMBeanServer();
        JmxTools.invoke(server, objectName, operation, null, null);
        logger.info("operation {} on Connector {} invoked success", (Object)operation, (Object)objectName);
    }

    public synchronized List<Connector> getConnectors(boolean includeRequestProcessors) throws Exception {
        boolean workerThreadNameSupported = true;
        if (!this.isInitialized()) {
            this.initialize();
        }
        ArrayList<Connector> connectors = new ArrayList<Connector>(this.poolNames.size());
        MBeanServer server = this.getContainerWrapper().getResourceResolver().getMBeanServer();
        for (ThreadPoolObjectName threadPoolObjectName : this.poolNames) {
            try {
                ObjectName poolName = threadPoolObjectName.getThreadPoolName();
                Connector connector = new Connector();
                String name = poolName.getKeyProperty("name");
                connector.setProtocolHandler(poolName.getKeyProperty("name"));
                if (name.startsWith("\"") && name.endsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String[] arr = name.split("-");
                String port = "-1";
                if (arr.length == 3) {
                    port = arr[2];
                }
                if (!"-1".equals(port)) {
                    String str = "Catalina:type=Connector,port=" + port;
                    ObjectName objectName = new ObjectName(str);
                    connector.setStatus(JmxTools.getStringAttr(server, objectName, "stateName"));
                    connector.setProtocol(JmxTools.getStringAttr(server, objectName, "protocol"));
                    connector.setSecure(Boolean.parseBoolean(JmxTools.getStringAttr(server, objectName, "secure")));
                    connector.setPort(JmxTools.getIntAttr(server, objectName, "port"));
                    connector.setLocalPort(JmxTools.getIntAttr(server, objectName, "localPort"));
                    connector.setSchema(JmxTools.getStringAttr(server, objectName, "schema"));
                }
                ObjectName grpName = threadPoolObjectName.getGlobalRequestProcessorName();
                connector.setMaxTime(JmxTools.getLongAttr(server, grpName, "maxTime"));
                connector.setProcessingTime(JmxTools.getLongAttr(server, grpName, "processingTime"));
                connector.setBytesReceived(JmxTools.getLongAttr(server, grpName, "bytesReceived"));
                connector.setBytesSent(JmxTools.getLongAttr(server, grpName, "bytesSent"));
                connector.setRequestCount(JmxTools.getIntAttr(server, grpName, "requestCount"));
                connector.setErrorCount(JmxTools.getIntAttr(server, grpName, "errorCount"));
                if (includeRequestProcessors) {
                    List<ObjectName> wrkNames = threadPoolObjectName.getRequestProcessorNames();
                    for (ObjectName wrkName : wrkNames) {
                        try {
                            RequestProcessor rp = new RequestProcessor();
                            rp.setName(wrkName.getKeyProperty("name"));
                            rp.setStage(JmxTools.getIntAttr(server, wrkName, "stage"));
                            rp.setProcessingTime(JmxTools.getLongAttr(server, wrkName, "requestProcessingTime"));
                            rp.setBytesSent(JmxTools.getLongAttr(server, wrkName, "requestBytesSent"));
                            rp.setBytesReceived(JmxTools.getLongAttr(server, wrkName, "requestBytesReceived"));
                            try {
                                rp.setRemoteAddr(JmxTools.getStringAttr(server, wrkName, "remoteAddr"));
                            }
                            catch (RuntimeOperationsException ex) {
                                logger.trace("", (Throwable)ex);
                            }
                            if (rp.getRemoteAddr() != null) {
                                if (InetAddress.getByName(rp.getRemoteAddr()).isLoopbackAddress()) {
                                    rp.setRemoteAddrLocale(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
                                } else {
                                    try (DatabaseReader reader = new DatabaseReader.Builder(new File(this.getClass().getClassLoader().getResource("GeoLite2-Country.mmdb").toURI())).withCache((NodeCache)new CHMCache()).build();){
                                        CountryResponse response = reader.country(InetAddress.getByName(rp.getRemoteAddr()));
                                        Country country = response.getCountry();
                                        rp.setRemoteAddrLocale(new Locale("", country.getIsoCode()));
                                    }
                                    catch (AddressNotFoundException e) {
                                        logger.debug("Address Not Found: {}", (Object)e.getMessage());
                                        logger.trace("", (Throwable)e);
                                    }
                                }
                            }
                            rp.setVirtualHost(JmxTools.getStringAttr(server, wrkName, "virtualHost"));
                            rp.setMethod(JmxTools.getStringAttr(server, wrkName, "method"));
                            rp.setCurrentUri(JmxTools.getStringAttr(server, wrkName, "currentUri"));
                            rp.setCurrentQueryString(JmxTools.getStringAttr(server, wrkName, "currentQueryString"));
                            rp.setProtocol(JmxTools.getStringAttr(server, wrkName, "protocol"));
                            if (workerThreadNameSupported && JmxTools.hasAttribute(server, wrkName, "workerThreadName")) {
                                rp.setWorkerThreadName(JmxTools.getStringAttr(server, wrkName, "workerThreadName"));
                                rp.setWorkerThreadNameSupported(true);
                            } else {
                                rp.setWorkerThreadNameSupported(false);
                                workerThreadNameSupported = false;
                            }
                            connector.addRequestProcessor(rp);
                        }
                        catch (InstanceNotFoundException e) {
                            logger.info("Failed to query RequestProcessor {}", (Object)wrkName);
                            logger.debug("", (Throwable)e);
                        }
                    }
                }
                connectors.add(connector);
            }
            catch (InstanceNotFoundException e) {
                logger.error("Failed to query entire thread pool {}", (Object)threadPoolObjectName);
                logger.debug("  Stack trace:", (Throwable)e);
            }
        }
        return connectors;
    }
}

