/*
 * Decompiled with CFR 0.152.
 */
package psiprobe;

import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import psiprobe.ProbeConfig;
import psiprobe.ProbeServlet;

public class ProbeInitializer
implements WebApplicationInitializer {
    public void onStartup(ServletContext servletContext) throws ServletException {
        try (AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();){
            rootContext.register(new Class[]{ProbeConfig.class});
            servletContext.setInitParameter("attribute.value.roles", "ROLE_MANAGER,ROLE_MANAGER-GUI");
            servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)rootContext));
        }
        ServletRegistration.Dynamic probe = servletContext.addServlet("probe", ProbeServlet.class);
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("contextConfigLocation", "");
        probe.setInitParameters(initParameters);
        probe.setLoadOnStartup(0);
        probe.addMapping(new String[]{"*.htm"});
        probe.addMapping(new String[]{"*.ajax"});
        probe.addMapping(new String[]{"/logs/*"});
        probe.addMapping(new String[]{"/chart.png"});
        FilterRegistration.Dynamic sitemesh = servletContext.addFilter("sitemesh", SiteMeshFilter.class);
        sitemesh.addMappingForUrlPatterns(EnumSet.of(DispatcherType.FORWARD, DispatcherType.REQUEST, DispatcherType.ERROR), false, new String[]{"/*"});
        FilterRegistration.Dynamic security = servletContext.addFilter("filterChainProxy", DelegatingFilterProxy.class);
        security.addMappingForUrlPatterns(EnumSet.of(DispatcherType.FORWARD, DispatcherType.REQUEST, DispatcherType.ERROR), false, new String[]{"/*"});
        servletContext.getSessionCookieConfig().setHttpOnly(true);
        EnumSet<SessionTrackingMode> trackingMode = EnumSet.of(SessionTrackingMode.COOKIE);
        servletContext.setSessionTrackingModes(trackingMode);
    }
}

