/*
 * Decompiled with CFR 0.152.
 */
package psiprobe;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.naming.ContextBindings;
import org.apache.naming.factory.ResourceLinkFactory;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import psiprobe.TomcatContainer;
import psiprobe.Utils;
import psiprobe.beans.ResourceResolverBean;
import psiprobe.model.FilterMapping;
import psiprobe.model.jsp.Item;
import psiprobe.model.jsp.Summary;

public abstract class AbstractTomcatContainer
implements TomcatContainer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NO_JSP_SERVLET = "Context '{}' does not have 'JSP' servlet";
    protected Host host;
    protected Connector[] connectors;
    protected ObjectName deployerOName;
    protected MBeanServer mbeanServer;

    @Override
    public void setWrapper(Wrapper wrapper) {
        Valve valve = this.createValve();
        if (wrapper != null) {
            this.host = (Host)wrapper.getParent().getParent();
            Engine engine = (Engine)this.host.getParent();
            Service service = engine.getService();
            this.connectors = service.findConnectors();
            try {
                this.deployerOName = new ObjectName(this.host.getParent().getName() + ":type=Deployer,host=" + this.host.getName());
            }
            catch (MalformedObjectNameException e) {
                this.logger.trace("", (Throwable)e);
            }
            this.host.getPipeline().addValve(valve);
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        } else if (this.host != null) {
            this.host.getPipeline().removeValve(valve);
        }
    }

    @Override
    public File getAppBase() {
        File base = new File(this.host.getAppBase());
        if (!base.isAbsolute()) {
            base = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        return base;
    }

    @Override
    public String getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        Host baseHost = null;
        for (Host thisContainer = this.host; thisContainer != null; thisContainer = thisContainer.getParent()) {
            if (!(thisContainer instanceof Host)) continue;
            baseHost = thisContainer;
        }
        if (baseHost != null) {
            configBase = new File(configBase, baseHost.getName());
        }
        return configBase.getAbsolutePath();
    }

    @Override
    public String getHostName() {
        return this.host.getName();
    }

    @Override
    public String getName() {
        return this.host.getParent().getName();
    }

    @Override
    public List<Context> findContexts() {
        ArrayList<Context> results = new ArrayList<Context>();
        for (Container child : this.host.findChildren()) {
            if (!(child instanceof Context)) continue;
            results.add((Context)child);
        }
        return results;
    }

    @Override
    public List<Connector> findConnectors() {
        return Collections.unmodifiableList(Arrays.asList(this.connectors));
    }

    @Override
    public boolean installContext(String contextName) throws Exception {
        contextName = this.formatContextName(contextName);
        this.installContextInternal(contextName);
        return this.findContext(contextName) != null;
    }

    @Override
    public void stop(String name) throws Exception {
        Context ctx = this.findContext(name);
        if (ctx != null) {
            ctx.stop();
        }
    }

    @Override
    public void start(String name) throws Exception {
        Context ctx = this.findContext(name);
        if (ctx != null) {
            ctx.start();
        }
    }

    @Override
    public void remove(String name) throws Exception {
        Context ctx = this.findContext(name = this.formatContextName(name));
        if (ctx != null) {
            try {
                this.stop(name);
            }
            catch (Exception e) {
                this.logger.info("Stopping '{}' threw this exception:", (Object)name, (Object)e);
            }
            File docBase = new File(ctx.getDocBase());
            File appDir = !docBase.isAbsolute() ? new File(this.getAppBase(), ctx.getDocBase()) : docBase;
            this.logger.debug("Deleting '{}'", (Object)appDir.getAbsolutePath());
            Utils.delete(appDir);
            String warFilename = this.formatContextFilename(name);
            File warFile = new File(this.getAppBase(), warFilename + ".war");
            this.logger.debug("Deleting '{}'", (Object)warFile.getAbsolutePath());
            Utils.delete(warFile);
            File configFile = this.getConfigFile(ctx);
            if (configFile != null) {
                this.logger.debug("Deleting '{}'", (Object)configFile.getAbsolutePath());
                Utils.delete(configFile);
            }
            this.removeInternal(name);
        }
    }

    private void removeInternal(String name) throws Exception {
        this.checkChanges(name);
    }

    @Override
    public void installWar(String name, URL url) throws Exception {
        this.checkChanges(name);
    }

    private void installContextInternal(String name) throws Exception {
        this.checkChanges(name);
    }

    @Override
    public Context findContext(String name) {
        String safeName = this.formatContextName(name);
        if (safeName == null) {
            return null;
        }
        Context result = this.findContextInternal(safeName);
        if (result == null && "".equals(safeName)) {
            result = this.findContextInternal("/");
        }
        return result;
    }

    @Override
    public String formatContextName(String name) {
        if (name == null) {
            return null;
        }
        String result = name.trim();
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        if ("/".equals(result) || "/ROOT".equals(result)) {
            result = "";
        }
        if (result.startsWith("/ROOT##")) {
            result = result.substring(5);
        }
        if (result.startsWith("/##")) {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    public String formatContextFilename(String contextName) {
        if (contextName == null) {
            return null;
        }
        if ("".equals(contextName)) {
            return "ROOT";
        }
        if (contextName.startsWith("/")) {
            return contextName.substring(1);
        }
        return contextName;
    }

    @Override
    public void discardWorkDir(Context context) {
        if (context instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)context;
            String path = standardContext.getWorkPath();
            this.logger.info("Discarding '{}'", (Object)path);
            Utils.delete(new File(path, "org"));
        } else {
            this.logger.error("context '{}' is not an instance of '{}', expected StandardContext", (Object)context.getName(), (Object)context.getClass().getName());
        }
    }

    @Override
    public String getServletFileNameForJsp(Context context, String jspName) {
        String servletName = null;
        ServletConfig servletConfig = (ServletConfig)context.findChild("jsp");
        if (servletConfig != null) {
            ServletContext sctx = context.getServletContext();
            EmbeddedServletOptions opt = new EmbeddedServletOptions(servletConfig, sctx);
            JspRuntimeContext jrctx = new JspRuntimeContext(sctx, (Options)opt);
            JspCompilationContext jcctx = this.createJspCompilationContext(jspName, (Options)opt, sctx, jrctx, null);
            servletName = jcctx.getServletJavaFileName();
        } else {
            this.logger.error(NO_JSP_SERVLET, (Object)context.getName());
        }
        return servletName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recompileJsps(Context context, Summary summary, List<String> names) {
        ServletConfig servletConfig = (ServletConfig)context.findChild("jsp");
        if (servletConfig != null) {
            if (summary != null) {
                ServletConfig servletConfig2 = servletConfig;
                synchronized (servletConfig2) {
                    ServletContext sctx = context.getServletContext();
                    EmbeddedServletOptions opt = new EmbeddedServletOptions(servletConfig, sctx);
                    JspRuntimeContext jrctx = new JspRuntimeContext(sctx, (Options)opt);
                    try (URLClassLoader classLoader = new URLClassLoader(new URL[0], context.getLoader().getClassLoader());){
                        for (String name : names) {
                            long time = System.currentTimeMillis();
                            JspCompilationContext jcctx = this.createJspCompilationContext(name, (Options)opt, sctx, jrctx, classLoader);
                            ClassLoader prevCl = ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader);
                            try {
                                Item item = summary.getItems().get(name);
                                if (item != null) {
                                    try {
                                        Compiler compiler = jcctx.createCompiler();
                                        compiler.compile();
                                        item.setState(2);
                                        item.setException(null);
                                        this.logger.info("Compiled '{}': OK", (Object)name);
                                    }
                                    catch (Exception e) {
                                        item.setState(3);
                                        item.setException(e);
                                        this.logger.error("Compiled '{}': FAILED", (Object)name, (Object)e);
                                    }
                                    item.setCompileTime(System.currentTimeMillis() - time);
                                    continue;
                                }
                                this.logger.error("{} is not on the summary list, ignored", (Object)name);
                            }
                            finally {
                                ClassUtils.overrideThreadContextClassLoader((ClassLoader)prevCl);
                            }
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("", (Throwable)e);
                    }
                    finally {
                        jrctx.destroy();
                    }
                }
            }
            this.logger.error("summary is null for '{}', request ignored", (Object)context.getName());
        } else {
            this.logger.error(NO_JSP_SERVLET, (Object)context.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listContextJsps(Context context, Summary summary, boolean compile) {
        ServletConfig servletConfig = (ServletConfig)context.findChild("jsp");
        if (servletConfig != null) {
            ServletConfig servletConfig2 = servletConfig;
            synchronized (servletConfig2) {
                ServletContext sctx = context.getServletContext();
                EmbeddedServletOptions opt = new EmbeddedServletOptions(servletConfig, sctx);
                JspRuntimeContext jrctx = new JspRuntimeContext(sctx, (Options)opt);
                try {
                    if (summary.getItems() == null) {
                        summary.setItems(new HashMap<String, Item>());
                    }
                    for (Item item : summary.getItems().values()) {
                        item.setMissing(true);
                    }
                    try (URLClassLoader urlcl = new URLClassLoader(new URL[0], context.getLoader().getClassLoader());){
                        this.compileItem("/", (Options)opt, context, jrctx, summary, urlcl, 0, compile);
                    }
                    catch (IOException e) {
                        this.logger.error("", (Throwable)e);
                    }
                }
                finally {
                    jrctx.destroy();
                }
            }
            HashMap<String, Item> hashMap = new HashMap<String, Item>();
            for (String key : summary.getItems().keySet()) {
                Item item = summary.getItems().get(key);
                if (item.isMissing()) continue;
                hashMap.put(key, item);
            }
            summary.setItems(hashMap);
        } else {
            this.logger.error(NO_JSP_SERVLET, (Object)context.getName());
        }
    }

    @Override
    public boolean getAvailable(Context context) {
        return context.getState().isAvailable();
    }

    @Override
    public File getConfigFile(Context context) {
        URL configUrl = context.getConfigFile();
        if (configUrl != null) {
            try {
                URI configUri = configUrl.toURI();
                if ("file".equals(configUri.getScheme())) {
                    return new File(configUri.getPath());
                }
            }
            catch (URISyntaxException ex) {
                this.logger.error("Could not convert URL to URI: '{}'", (Object)configUrl, (Object)ex);
            }
        }
        return null;
    }

    @Override
    public void bindToContext(Context context) throws NamingException {
        this.changeContextBinding(context, true);
    }

    @Override
    public void unbindFromContext(Context context) throws NamingException {
        this.changeContextBinding(context, false);
    }

    protected void registerGlobalResourceAccess(ContextResourceLink resourceLink) {
        ResourceLinkFactory.registerGlobalResourceAccess((javax.naming.Context)ResourceResolverBean.getGlobalNamingContext(), (String)resourceLink.getName(), (String)resourceLink.getGlobal());
    }

    private void changeContextBinding(Context context, boolean bind) throws NamingException {
        Object token = this.getNamingToken(context);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (bind) {
            ContextBindings.bindClassLoader((Object)context, (Object)token, (ClassLoader)loader);
        } else {
            ContextBindings.unbindClassLoader((Object)context, (Object)token, (ClassLoader)loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileItem(String jspName, Options opt, Context ctx, JspRuntimeContext jrctx, Summary summary, URLClassLoader classLoader, int level, boolean compile) {
        ServletContext sctx = ctx.getServletContext();
        Set paths = sctx.getResourcePaths(jspName);
        if (paths != null) {
            for (String name : paths) {
                boolean isJsp = false;
                try {
                    isJsp = name.endsWith(".jsp") || name.endsWith(".jspx") || opt.getJspConfig().isJspPage(name);
                }
                catch (Exception e) {
                    this.logger.info("isJspPage() thrown an error for '{}'", (Object)name, (Object)e);
                }
                if (isJsp) {
                    JspCompilationContext jcctx = this.createJspCompilationContext(name, opt, sctx, jrctx, classLoader);
                    ClassLoader prevCl = ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader);
                    try {
                        Item item = summary.getItems().get(name);
                        if (item == null) {
                            item = new Item();
                            item.setName(name);
                        }
                        item.setLevel(level);
                        item.setCompileTime(-1L);
                        Long[] objects = this.getResourceAttributes(name, ctx);
                        item.setSize(objects[0]);
                        item.setLastModified(objects[1]);
                        long time = System.currentTimeMillis();
                        try {
                            Compiler compiler = jcctx.createCompiler();
                            if (compile) {
                                compiler.compile();
                                item.setState(2);
                                item.setException(null);
                            } else if (!compiler.isOutDated()) {
                                item.setState(2);
                                item.setException(null);
                            } else if (item.getState() != 3) {
                                item.setState(1);
                                item.setException(null);
                            }
                            this.logger.info("Compiled '{}': OK", (Object)name);
                        }
                        catch (Exception e) {
                            item.setState(3);
                            item.setException(e);
                            this.logger.info("Compiled '{}': FAILED", (Object)name, (Object)e);
                        }
                        if (compile) {
                            item.setCompileTime(System.currentTimeMillis() - time);
                        }
                        item.setMissing(false);
                        summary.getItems().put(name, item);
                        continue;
                    }
                    finally {
                        ClassUtils.overrideThreadContextClassLoader((ClassLoader)prevCl);
                        continue;
                    }
                }
                this.compileItem(name, opt, ctx, jrctx, summary, classLoader, level + 1, compile);
            }
        } else {
            this.logger.debug("getResourcePaths() is null for '{}'. Empty dir? Or Tomcat bug?", (Object)jspName);
        }
    }

    protected Context findContextInternal(String name) {
        return (Context)this.host.findChild(name);
    }

    protected void checkChanges(String name) throws Exception {
        Boolean result = (Boolean)this.mbeanServer.invoke(this.deployerOName, "isServiced", new String[]{name}, new String[]{String.class.getName()});
        if (!result.booleanValue()) {
            this.mbeanServer.invoke(this.deployerOName, "addServiced", new String[]{name}, new String[]{String.class.getName()});
            try {
                this.mbeanServer.invoke(this.deployerOName, "check", new String[]{name}, new String[]{String.class.getName()});
            }
            catch (Throwable throwable) {
                this.mbeanServer.invoke(this.deployerOName, "removeServiced", new String[]{name}, new String[]{String.class.getName()});
                throw throwable;
            }
            this.mbeanServer.invoke(this.deployerOName, "removeServiced", new String[]{name}, new String[]{String.class.getName()});
        }
    }

    protected abstract Object getNamingToken(Context var1);

    protected abstract JspCompilationContext createJspCompilationContext(String var1, Options var2, ServletContext var3, JspRuntimeContext var4, ClassLoader var5);

    protected abstract Valve createValve();

    protected void addFilterMapping(String filterName, String dispatcherMap, String filterClass, String[] types, List<FilterMapping> results, FilterMapType filterMapType) {
        for (String type : types) {
            FilterMapping fm = new FilterMapping();
            if (filterMapType == FilterMapType.URL) {
                fm.setUrl(type);
            } else {
                fm.setServletName(type);
            }
            fm.setFilterName(filterName);
            fm.setDispatcherMap(dispatcherMap);
            fm.setFilterClass(filterClass);
            results.add(fm);
        }
    }

    public static enum FilterMapType {
        URL,
        SERVLET_NAME;

    }
}

