/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import io.ipfs.api.NamedStreamable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;

public class Multipart {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream out;
    private PrintWriter writer;

    public Multipart(String requestURL, String charset) {
        this.charset = charset;
        this.boundary = Multipart.createBoundary();
        try {
            URL url = new URL(requestURL);
            this.httpConn = (HttpURLConnection)url.openConnection();
            this.httpConn.setUseCaches(false);
            this.httpConn.setDoOutput(true);
            this.httpConn.setDoInput(true);
            this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            this.httpConn.setRequestProperty("User-Agent", "Java IPFS CLient");
            this.out = this.httpConn.getOutputStream();
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.out, charset), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String createBoundary() {
        Random r = new Random();
        String allowed = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            b.append(allowed.charAt(r.nextInt(allowed.length())));
        }
        return b.toString();
    }

    public void addFormField(String name, String value) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=").append(this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addSubtree(Path parentPath, NamedStreamable dir) throws IOException {
        Path dirPath = parentPath.resolve(dir.getName().get());
        this.addDirectoryPart(dirPath);
        for (NamedStreamable f : dir.getChildren()) {
            if (f.isDirectory()) {
                this.addSubtree(dirPath, f);
                continue;
            }
            this.addFilePart("file", dirPath, f);
        }
    }

    public void addDirectoryPart(Path path) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: file; filename=\"").append(Multipart.encode(path.toString())).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: application/x-directory").append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    private static String encode(String in) {
        try {
            return URLEncoder.encode(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void addFilePart(String fieldName, Path parent, NamedStreamable uploadFile) {
        Optional<String> fileName = uploadFile.getName().map(n -> Multipart.encode(parent.resolve((String)n).toString().replace('\\', '/')));
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        if (!fileName.isPresent()) {
            this.writer.append("Content-Disposition: file; name=\"").append(fieldName).append("\";").append(LINE_FEED);
        } else {
            this.writer.append("Content-Disposition: file; filename=\"").append(fileName.get()).append("\";").append(LINE_FEED);
        }
        this.writer.append("Content-Type: application/octet-stream").append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        try {
            int r;
            InputStream inputStream = uploadFile.getInputStream();
            byte[] buffer = new byte[4096];
            while ((r = inputStream.read(buffer)) != -1) {
                this.out.write(buffer, 0, r);
            }
            this.out.flush();
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name + ": " + value).append(LINE_FEED);
        this.writer.flush();
    }

    public String finish() {
        StringBuilder b = new StringBuilder();
        this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
        this.writer.close();
        try {
            BufferedReader reader;
            int status = this.httpConn.getResponseCode();
            if (status == 200) {
                String line;
                reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    b.append(line);
                }
            } else {
                try {
                    String line;
                    BufferedReader reader2 = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
                    while ((line = reader2.readLine()) != null) {
                        b.append(line);
                    }
                    reader2.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new IOException("Server returned status: " + status + " with body: " + b.toString() + " and Trailer header: " + this.httpConn.getHeaderFields().get("Trailer"));
            }
            reader.close();
            this.httpConn.disconnect();
            return b.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

