/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.tinypinyin.android.asset.lexicons;

import android.content.Context;
import com.github.promeg.pinyinhelper.PinyinMapDict;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public abstract class AndroidAssetDict
extends PinyinMapDict {
    final Context mContext;
    final Map<String, String[]> mDict;

    protected abstract String assetFileName();

    public AndroidAssetDict(Context context) {
        this.mContext = context.getApplicationContext();
        this.mDict = new HashMap<String, String[]>();
        this.init();
    }

    public Map<String, String[]> mapping() {
        return this.mDict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(this.mContext.getAssets().open(this.assetFileName())));
            while ((line = reader.readLine()) != null) {
                String[] keyAndValue = line.split("\\s+");
                if (keyAndValue == null || keyAndValue.length != 2) continue;
                String[] pinyinStrs = keyAndValue[0].split("'");
                this.mDict.put(keyAndValue[1], pinyinStrs);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

