/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarPagerView;
import com.prolificinteractive.materialcalendarview.DateRangeIndex;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.ChronoLocalDate;

abstract class CalendarPagerAdapter<V extends CalendarPagerView>
extends PagerAdapter {
    private final ArrayDeque<V> currentViews;
    protected final MaterialCalendarView mcv;
    private final CalendarDay today;
    @NonNull
    private TitleFormatter titleFormatter = TitleFormatter.DEFAULT;
    private Integer color = null;
    private Integer dateTextAppearance = null;
    private Integer weekDayTextAppearance = null;
    private int showOtherDates = 4;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private DateRangeIndex rangeIndex;
    private List<CalendarDay> selectedDates = new ArrayList<CalendarDay>();
    private WeekDayFormatter weekDayFormatter = WeekDayFormatter.DEFAULT;
    private DayFormatter dayFormatter;
    private DayFormatter dayFormatterContentDescription = this.dayFormatter = DayFormatter.DEFAULT;
    private List<DayViewDecorator> decorators = new ArrayList<DayViewDecorator>();
    private List<DecoratorResult> decoratorResults = null;
    private boolean selectionEnabled = true;
    boolean showWeekDays;

    CalendarPagerAdapter(MaterialCalendarView mcv) {
        this.mcv = mcv;
        this.today = CalendarDay.today();
        this.currentViews = new ArrayDeque();
        this.currentViews.iterator();
        this.setRangeDates(null, null);
    }

    public void setDecorators(List<DayViewDecorator> decorators) {
        this.decorators = decorators;
        this.invalidateDecorators();
    }

    public void invalidateDecorators() {
        this.decoratorResults = new ArrayList<DecoratorResult>();
        for (DayViewDecorator decorator : this.decorators) {
            DayViewFacade facade = new DayViewFacade();
            decorator.decorate(facade);
            if (!facade.isDecorated()) continue;
            this.decoratorResults.add(new DecoratorResult(decorator, facade));
        }
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setDayViewDecorators(this.decoratorResults);
        }
    }

    public int getCount() {
        return this.rangeIndex.getCount();
    }

    public CharSequence getPageTitle(int position) {
        return this.titleFormatter.format(this.getItem(position));
    }

    public CalendarPagerAdapter<?> migrateStateAndReturn(CalendarPagerAdapter<?> newAdapter) {
        newAdapter.titleFormatter = this.titleFormatter;
        newAdapter.color = this.color;
        newAdapter.dateTextAppearance = this.dateTextAppearance;
        newAdapter.weekDayTextAppearance = this.weekDayTextAppearance;
        newAdapter.showOtherDates = this.showOtherDates;
        newAdapter.minDate = this.minDate;
        newAdapter.maxDate = this.maxDate;
        newAdapter.selectedDates = this.selectedDates;
        newAdapter.weekDayFormatter = this.weekDayFormatter;
        newAdapter.dayFormatter = this.dayFormatter;
        newAdapter.dayFormatterContentDescription = this.dayFormatterContentDescription;
        newAdapter.decorators = this.decorators;
        newAdapter.decoratorResults = this.decoratorResults;
        newAdapter.selectionEnabled = this.selectionEnabled;
        return newAdapter;
    }

    public int getIndexForDay(CalendarDay day) {
        if (day == null) {
            return this.getCount() / 2;
        }
        if (this.minDate != null && day.isBefore(this.minDate)) {
            return 0;
        }
        if (this.maxDate != null && day.isAfter(this.maxDate)) {
            return this.getCount() - 1;
        }
        return this.rangeIndex.indexOf(day);
    }

    protected abstract V createView(int var1);

    protected abstract int indexOf(V var1);

    protected abstract boolean isInstanceOfView(Object var1);

    protected abstract DateRangeIndex createRangeIndex(CalendarDay var1, CalendarDay var2);

    public int getItemPosition(@NonNull Object object) {
        if (!this.isInstanceOfView(object)) {
            return -2;
        }
        CalendarPagerView pagerView = (CalendarPagerView)((Object)object);
        CalendarDay firstViewDay = pagerView.getFirstViewDay();
        if (firstViewDay == null) {
            return -2;
        }
        int index = this.indexOf((CalendarPagerView)((Object)object));
        if (index < 0) {
            return -2;
        }
        return index;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        V pagerView = this.createView(position);
        pagerView.setContentDescription(this.mcv.getCalendarContentDescription());
        pagerView.setAlpha(0.0f);
        ((CalendarPagerView)((Object)pagerView)).setSelectionEnabled(this.selectionEnabled);
        ((CalendarPagerView)((Object)pagerView)).setWeekDayFormatter(this.weekDayFormatter);
        ((CalendarPagerView)((Object)pagerView)).setDayFormatter(this.dayFormatter);
        ((CalendarPagerView)((Object)pagerView)).setDayFormatterContentDescription(this.dayFormatterContentDescription);
        if (this.color != null) {
            ((CalendarPagerView)((Object)pagerView)).setSelectionColor(this.color);
        }
        if (this.dateTextAppearance != null) {
            ((CalendarPagerView)((Object)pagerView)).setDateTextAppearance(this.dateTextAppearance);
        }
        if (this.weekDayTextAppearance != null) {
            ((CalendarPagerView)((Object)pagerView)).setWeekDayTextAppearance(this.weekDayTextAppearance);
        }
        ((CalendarPagerView)((Object)pagerView)).setShowOtherDates(this.showOtherDates);
        ((CalendarPagerView)((Object)pagerView)).setMinimumDate(this.minDate);
        ((CalendarPagerView)((Object)pagerView)).setMaximumDate(this.maxDate);
        ((CalendarPagerView)((Object)pagerView)).setSelectedDates(this.selectedDates);
        container.addView(pagerView);
        this.currentViews.add(pagerView);
        ((CalendarPagerView)((Object)pagerView)).setDayViewDecorators(this.decoratorResults);
        return pagerView;
    }

    public void setShowWeekDays(boolean showWeekDays) {
        this.showWeekDays = showWeekDays;
    }

    public boolean isShowWeekDays() {
        return this.showWeekDays;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.selectionEnabled = enabled;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setSelectionEnabled(this.selectionEnabled);
        }
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        CalendarPagerView pagerView = (CalendarPagerView)((Object)object);
        this.currentViews.remove((Object)pagerView);
        container.removeView((View)pagerView);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void setTitleFormatter(@Nullable TitleFormatter titleFormatter) {
        this.titleFormatter = titleFormatter == null ? TitleFormatter.DEFAULT : titleFormatter;
    }

    public void setSelectionColor(int color) {
        this.color = color;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setSelectionColor(color);
        }
    }

    public void setDateTextAppearance(int taId) {
        if (taId == 0) {
            return;
        }
        this.dateTextAppearance = taId;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setDateTextAppearance(taId);
        }
    }

    public void setShowOtherDates(int showFlags) {
        this.showOtherDates = showFlags;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setShowOtherDates(showFlags);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        this.weekDayFormatter = formatter;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setWeekDayFormatter(formatter);
        }
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.dayFormatterContentDescription = this.dayFormatterContentDescription == this.dayFormatter ? formatter : this.dayFormatterContentDescription;
        this.dayFormatter = formatter;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setDayFormatter(formatter);
        }
    }

    public void setDayFormatterContentDescription(DayFormatter formatter) {
        this.dayFormatterContentDescription = formatter;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setDayFormatterContentDescription(formatter);
        }
    }

    public int getShowOtherDates() {
        return this.showOtherDates;
    }

    public void setWeekDayTextAppearance(int taId) {
        if (taId == 0) {
            return;
        }
        this.weekDayTextAppearance = taId;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setWeekDayTextAppearance(taId);
        }
    }

    public void setRangeDates(CalendarDay min, CalendarDay max) {
        this.minDate = min;
        this.maxDate = max;
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setMinimumDate(min);
            pagerView.setMaximumDate(max);
        }
        if (min == null) {
            min = CalendarDay.from(this.today.getYear() - 200, this.today.getMonth(), this.today.getDay());
        }
        if (max == null) {
            max = CalendarDay.from(this.today.getYear() + 200, this.today.getMonth(), this.today.getDay());
        }
        this.rangeIndex = this.createRangeIndex(min, max);
        this.notifyDataSetChanged();
        this.invalidateSelectedDates();
    }

    public DateRangeIndex getRangeIndex() {
        return this.rangeIndex;
    }

    public void clearSelections() {
        this.selectedDates.clear();
        this.invalidateSelectedDates();
    }

    public void setDateSelected(CalendarDay day, boolean selected) {
        if (selected) {
            if (!this.selectedDates.contains(day)) {
                this.selectedDates.add(day);
                this.invalidateSelectedDates();
            }
        } else if (this.selectedDates.contains(day)) {
            this.selectedDates.remove(day);
            this.invalidateSelectedDates();
        }
    }

    public void selectRange(CalendarDay first, CalendarDay last) {
        this.selectedDates.clear();
        LocalDate temp = LocalDate.of((int)first.getYear(), (int)first.getMonth(), (int)first.getDay());
        LocalDate end = last.getDate();
        while (temp.isBefore((ChronoLocalDate)end) || temp.equals((Object)end)) {
            this.selectedDates.add(CalendarDay.from(temp));
            temp = temp.plusDays(1L);
        }
        this.invalidateSelectedDates();
    }

    private void invalidateSelectedDates() {
        this.validateSelectedDates();
        for (CalendarPagerView pagerView : this.currentViews) {
            pagerView.setSelectedDates(this.selectedDates);
        }
    }

    private void validateSelectedDates() {
        for (int i = 0; i < this.selectedDates.size(); ++i) {
            CalendarDay date = this.selectedDates.get(i);
            if ((this.minDate == null || !this.minDate.isAfter(date)) && (this.maxDate == null || !this.maxDate.isBefore(date))) continue;
            this.selectedDates.remove(i);
            this.mcv.onDateUnselected(date);
            --i;
        }
    }

    public CalendarDay getItem(int position) {
        return this.rangeIndex.getItem(position);
    }

    @NonNull
    public List<CalendarDay> getSelectedDates() {
        return Collections.unmodifiableList(this.selectedDates);
    }

    protected int getDateTextAppearance() {
        return this.dateTextAppearance == null ? 0 : this.dateTextAppearance;
    }

    protected int getWeekDayTextAppearance() {
        return this.weekDayTextAppearance == null ? 0 : this.weekDayTextAppearance;
    }
}

