/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarPagerAdapter;
import com.prolificinteractive.materialcalendarview.DateRangeIndex;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.MonthView;
import org.threeten.bp.LocalDate;
import org.threeten.bp.Period;

class MonthPagerAdapter
extends CalendarPagerAdapter<MonthView> {
    MonthPagerAdapter(MaterialCalendarView mcv) {
        super(mcv);
    }

    @Override
    protected MonthView createView(int position) {
        return new MonthView(this.mcv, this.getItem(position), this.mcv.getFirstDayOfWeek(), this.showWeekDays);
    }

    @Override
    protected int indexOf(MonthView view) {
        CalendarDay month = view.getMonth();
        return this.getRangeIndex().indexOf(month);
    }

    @Override
    protected boolean isInstanceOfView(Object object) {
        return object instanceof MonthView;
    }

    @Override
    protected DateRangeIndex createRangeIndex(CalendarDay min, CalendarDay max) {
        return new Monthly(min, max);
    }

    public static class Monthly
    implements DateRangeIndex {
        private final CalendarDay min;
        private final int count;

        public Monthly(@NonNull CalendarDay min, @NonNull CalendarDay max) {
            this.min = CalendarDay.from(min.getYear(), min.getMonth(), 1);
            this.count = this.indexOf(max) + 1;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int indexOf(CalendarDay day) {
            return (int)Period.between((LocalDate)this.min.getDate().withDayOfMonth(1), (LocalDate)day.getDate().withDayOfMonth(1)).toTotalMonths();
        }

        @Override
        public CalendarDay getItem(int position) {
            return CalendarDay.from(this.min.getDate().plusMonths((long)position));
        }
    }
}

