/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.AppCompatTextView;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.Experimental;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.Calendar;

@Experimental
@SuppressLint(value={"ViewConstructor"})
class WeekDayView
extends AppCompatTextView {
    private WeekDayFormatter formatter = WeekDayFormatter.DEFAULT;
    private int dayOfWeek;

    public WeekDayView(Context context, int dayOfWeek) {
        super(context);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDayOfWeek(dayOfWeek);
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        this.formatter = formatter == null ? WeekDayFormatter.DEFAULT : formatter;
        this.setDayOfWeek(this.dayOfWeek);
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        this.setText(this.formatter.format(dayOfWeek));
    }

    public void setDayOfWeek(Calendar calendar) {
        this.setDayOfWeek(CalendarUtils.getDayOfWeek(calendar));
    }
}

