/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarMode;
import com.prolificinteractive.materialcalendarview.CalendarPager;
import com.prolificinteractive.materialcalendarview.CalendarPagerAdapter;
import com.prolificinteractive.materialcalendarview.DayView;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DirectionButton;
import com.prolificinteractive.materialcalendarview.Experimental;
import com.prolificinteractive.materialcalendarview.MonthPagerAdapter;
import com.prolificinteractive.materialcalendarview.MonthView;
import com.prolificinteractive.materialcalendarview.OnDateSelectedListener;
import com.prolificinteractive.materialcalendarview.OnMonthChangedListener;
import com.prolificinteractive.materialcalendarview.R;
import com.prolificinteractive.materialcalendarview.TitleChanger;
import com.prolificinteractive.materialcalendarview.WeekPagerAdapter;
import com.prolificinteractive.materialcalendarview.format.ArrayWeekDayFormatter;
import com.prolificinteractive.materialcalendarview.format.DateFormatTitleFormatter;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.MonthArrayTitleFormatter;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MaterialCalendarView
extends ViewGroup {
    public static final int SELECTION_MODE_NONE = 0;
    public static final int SELECTION_MODE_SINGLE = 1;
    public static final int SELECTION_MODE_MULTIPLE = 2;
    public static final int SHOW_NONE = 0;
    public static final int SHOW_OTHER_MONTHS = 1;
    public static final int SHOW_OUT_OF_RANGE = 2;
    public static final int SHOW_DECORATED_DISABLED = 4;
    public static final int SHOW_DEFAULTS = 4;
    public static final int SHOW_ALL = 7;
    public static final int DEFAULT_TILE_SIZE_DP = 44;
    private static final int DEFAULT_DAYS_IN_WEEK = 7;
    private static final int DEFAULT_MAX_WEEKS = 6;
    private static final int DAY_NAMES_ROW = 1;
    private static final TitleFormatter DEFAULT_TITLE_FORMATTER = new DateFormatTitleFormatter();
    private final TitleChanger titleChanger;
    private final TextView title;
    private final DirectionButton buttonPast;
    private final DirectionButton buttonFuture;
    private final CalendarPager pager;
    private CalendarPagerAdapter<?> adapter;
    private CalendarDay currentMonth;
    private LinearLayout topbar;
    private CalendarMode calendarMode;
    private boolean mDynamicHeightEnabled;
    private final ArrayList<DayViewDecorator> dayViewDecorators = new ArrayList();
    private final View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v == MaterialCalendarView.this.buttonFuture) {
                MaterialCalendarView.this.pager.setCurrentItem(MaterialCalendarView.this.pager.getCurrentItem() + 1, true);
            } else if (v == MaterialCalendarView.this.buttonPast) {
                MaterialCalendarView.this.pager.setCurrentItem(MaterialCalendarView.this.pager.getCurrentItem() - 1, true);
            }
        }
    };
    private final ViewPager.OnPageChangeListener pageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageSelected(int position) {
            MaterialCalendarView.this.titleChanger.setPreviousMonth(MaterialCalendarView.this.currentMonth);
            MaterialCalendarView.this.currentMonth = MaterialCalendarView.this.adapter.getItem(position);
            MaterialCalendarView.this.updateUi();
            MaterialCalendarView.this.dispatchOnMonthChanged(MaterialCalendarView.this.currentMonth);
        }

        public void onPageScrollStateChanged(int state) {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }
    };
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private OnDateSelectedListener listener;
    private OnMonthChangedListener monthListener;
    CharSequence calendarContentDescription;
    private int accentColor = 0;
    private int arrowColor = -16777216;
    private Drawable leftArrowMask;
    private Drawable rightArrowMask;
    private int tileHeight = -1;
    private int tileWidth = -1;
    @SelectionMode
    private int selectionMode = 1;
    private boolean allowClickDaysOutsideCurrentMonth = true;
    private int firstDayOfWeek;

    public MaterialCalendarView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterialCalendarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (Build.VERSION.SDK_INT >= 19) {
            this.setClipToPadding(false);
            this.setClipChildren(false);
        } else {
            this.setClipChildren(true);
            this.setClipToPadding(true);
        }
        this.buttonPast = new DirectionButton(this.getContext());
        this.buttonPast.setContentDescription(this.getContext().getString(R.string.previous));
        this.title = new TextView(this.getContext());
        this.buttonFuture = new DirectionButton(this.getContext());
        this.buttonFuture.setContentDescription(this.getContext().getString(R.string.next));
        this.pager = new CalendarPager(this.getContext());
        this.title.setOnClickListener(this.onClickListener);
        this.buttonPast.setOnClickListener(this.onClickListener);
        this.buttonFuture.setOnClickListener(this.onClickListener);
        this.titleChanger = new TitleChanger(this.title);
        this.titleChanger.setTitleFormatter(DEFAULT_TITLE_FORMATTER);
        this.pager.setOnPageChangeListener(this.pageChangeListener);
        this.pager.setPageTransformer(false, new ViewPager.PageTransformer(){

            public void transformPage(View page, float position) {
                position = (float)Math.sqrt(1.0f - Math.abs(position));
                page.setAlpha(position);
            }
        });
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaterialCalendarView, 0, 0);
        try {
            int tileHeight;
            int tileWidth;
            int calendarModeIndex = a.getInteger(R.styleable.MaterialCalendarView_mcv_calendarMode, 0);
            this.firstDayOfWeek = a.getInteger(R.styleable.MaterialCalendarView_mcv_firstDayOfWeek, -1);
            if (this.firstDayOfWeek < 0) {
                this.firstDayOfWeek = Calendar.getInstance().getFirstDayOfWeek();
            }
            this.setCalendarDisplayMode(CalendarMode.values()[calendarModeIndex]);
            int tileSize = a.getDimensionPixelSize(R.styleable.MaterialCalendarView_mcv_tileSize, -1);
            if (tileSize > 0) {
                this.setTileSize(tileSize);
            }
            if ((tileWidth = a.getDimensionPixelSize(R.styleable.MaterialCalendarView_mcv_tileWidth, -1)) > 0) {
                this.setTileWidth(tileWidth);
            }
            if ((tileHeight = a.getDimensionPixelSize(R.styleable.MaterialCalendarView_mcv_tileHeight, -1)) > 0) {
                this.setTileHeight(tileHeight);
            }
            this.setArrowColor(a.getColor(R.styleable.MaterialCalendarView_mcv_arrowColor, -16777216));
            Drawable leftMask = a.getDrawable(R.styleable.MaterialCalendarView_mcv_leftArrowMask);
            if (leftMask == null) {
                leftMask = this.getResources().getDrawable(R.drawable.mcv_action_previous);
            }
            this.setLeftArrowMask(leftMask);
            Drawable rightMask = a.getDrawable(R.styleable.MaterialCalendarView_mcv_rightArrowMask);
            if (rightMask == null) {
                rightMask = this.getResources().getDrawable(R.drawable.mcv_action_next);
            }
            this.setRightArrowMask(rightMask);
            this.setSelectionColor(a.getColor(R.styleable.MaterialCalendarView_mcv_selectionColor, MaterialCalendarView.getThemeAccentColor(context)));
            CharSequence[] array = a.getTextArray(R.styleable.MaterialCalendarView_mcv_weekDayLabels);
            if (array != null) {
                this.setWeekDayFormatter(new ArrayWeekDayFormatter(array));
            }
            if ((array = a.getTextArray(R.styleable.MaterialCalendarView_mcv_monthLabels)) != null) {
                this.setTitleFormatter(new MonthArrayTitleFormatter(array));
            }
            this.setHeaderTextAppearance(a.getResourceId(R.styleable.MaterialCalendarView_mcv_headerTextAppearance, R.style.TextAppearance_MaterialCalendarWidget_Header));
            this.setWeekDayTextAppearance(a.getResourceId(R.styleable.MaterialCalendarView_mcv_weekDayTextAppearance, R.style.TextAppearance_MaterialCalendarWidget_WeekDay));
            this.setDateTextAppearance(a.getResourceId(R.styleable.MaterialCalendarView_mcv_dateTextAppearance, R.style.TextAppearance_MaterialCalendarWidget_Date));
            this.setShowOtherDates(a.getInteger(R.styleable.MaterialCalendarView_mcv_showOtherDates, 4));
            this.setAllowClickDaysOutsideCurrentMonth(a.getBoolean(R.styleable.MaterialCalendarView_mcv_allowClickDaysOutsideCurrentMonth, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            a.recycle();
        }
        this.adapter.setTitleFormatter(DEFAULT_TITLE_FORMATTER);
        this.setupChildren();
        this.currentMonth = CalendarDay.today();
        this.setCurrentDate(this.currentMonth);
        if (this.isInEditMode()) {
            this.removeView((View)this.pager);
            MonthView monthView = new MonthView(this, this.currentMonth, this.getFirstDayOfWeek());
            monthView.setSelectionColor(this.getSelectionColor());
            monthView.setDateTextAppearance(this.adapter.getDateTextAppearance());
            monthView.setWeekDayTextAppearance(this.adapter.getWeekDayTextAppearance());
            monthView.setShowOtherDates(this.getShowOtherDates());
            this.addView((View)monthView, (ViewGroup.LayoutParams)new LayoutParams(this.calendarMode.visibleWeeksCount + 1));
        }
    }

    private void setupChildren() {
        this.topbar = new LinearLayout(this.getContext());
        this.topbar.setOrientation(0);
        this.topbar.setClipChildren(false);
        this.topbar.setClipToPadding(false);
        this.addView((View)this.topbar, (ViewGroup.LayoutParams)new LayoutParams(1));
        this.buttonPast.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.buttonPast.setImageResource(R.drawable.mcv_action_previous);
        this.topbar.addView((View)this.buttonPast, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        this.title.setGravity(17);
        this.topbar.addView((View)this.title, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 5.0f));
        this.buttonFuture.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.buttonFuture.setImageResource(R.drawable.mcv_action_next);
        this.topbar.addView((View)this.buttonFuture, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        this.pager.setId(R.id.mcv_pager);
        this.pager.setOffscreenPageLimit(1);
        this.addView((View)this.pager, (ViewGroup.LayoutParams)new LayoutParams(this.calendarMode.visibleWeeksCount + 1));
    }

    private void updateUi() {
        this.titleChanger.change(this.currentMonth);
        this.buttonPast.setEnabled(this.canGoBack());
        this.buttonFuture.setEnabled(this.canGoForward());
    }

    public void setSelectionMode(@SelectionMode int mode) {
        int oldMode = this.selectionMode;
        switch (mode) {
            case 2: {
                this.selectionMode = 2;
                break;
            }
            default: {
                List<CalendarDay> dates;
                this.selectionMode = 1;
                if (oldMode != 2 || (dates = this.getSelectedDates()).isEmpty()) break;
                this.setSelectedDate(this.getSelectedDate());
                break;
            }
            case 0: {
                this.selectionMode = 0;
                if (oldMode == 0) break;
                this.clearSelection();
            }
        }
        this.adapter.setSelectionEnabled(this.selectionMode != 0);
    }

    public void goToPrevious() {
        if (this.canGoBack()) {
            this.pager.setCurrentItem(this.pager.getCurrentItem() - 1, true);
        }
    }

    public void goToNext() {
        if (this.canGoForward()) {
            this.pager.setCurrentItem(this.pager.getCurrentItem() + 1, true);
        }
    }

    @Experimental
    public void setCalendarDisplayMode(CalendarMode mode) {
        CalendarPagerAdapter newAdapter;
        if (this.calendarMode != null && this.calendarMode.equals((Object)mode)) {
            return;
        }
        switch (mode) {
            case MONTHS: {
                newAdapter = new MonthPagerAdapter(this);
                break;
            }
            case WEEKS: {
                newAdapter = new WeekPagerAdapter(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided display mode which is not yet implemented");
            }
        }
        this.adapter = this.adapter == null ? newAdapter : this.adapter.migrateStateAndReturn(newAdapter);
        this.pager.setAdapter(this.adapter);
        this.setRangeDates(this.minDate, this.maxDate);
        this.calendarMode = mode;
        this.pager.setLayoutParams((ViewGroup.LayoutParams)new LayoutParams(this.calendarMode.visibleWeeksCount + 1));
        this.setCurrentDate(this.selectionMode == 1 && !this.adapter.getSelectedDates().isEmpty() ? this.adapter.getSelectedDates().get(0) : CalendarDay.today());
        this.invalidateDecorators();
        this.updateUi();
    }

    @SelectionMode
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Deprecated
    public int getTileSize() {
        return Math.max(this.tileHeight, this.tileWidth);
    }

    public void setTileSize(int size) {
        this.tileWidth = size;
        this.tileHeight = size;
        this.requestLayout();
    }

    public void setTileSizeDp(int tileSizeDp) {
        this.setTileSize(this.dpToPx(tileSizeDp));
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int height) {
        this.tileHeight = height;
        this.requestLayout();
    }

    public void setTileHeightDp(int tileHeightDp) {
        this.setTileHeight(this.dpToPx(tileHeightDp));
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int width) {
        this.tileWidth = width;
        this.requestLayout();
    }

    public void setTileWidthDp(int tileWidthDp) {
        this.setTileWidth(this.dpToPx(tileWidthDp));
    }

    private int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public boolean canGoForward() {
        return this.pager.getCurrentItem() < this.adapter.getCount() - 1;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.pager.dispatchTouchEvent(event);
    }

    public boolean canGoBack() {
        return this.pager.getCurrentItem() > 0;
    }

    public int getSelectionColor() {
        return this.accentColor;
    }

    public void setSelectionColor(int color) {
        if (color == 0) {
            if (!this.isInEditMode()) {
                return;
            }
            color = -7829368;
        }
        this.accentColor = color;
        this.adapter.setSelectionColor(color);
        this.invalidate();
    }

    public int getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(int color) {
        if (color == 0) {
            return;
        }
        this.arrowColor = color;
        this.buttonPast.setColor(color);
        this.buttonFuture.setColor(color);
        this.invalidate();
    }

    public void setContentDescriptionArrowPast(CharSequence description) {
        this.buttonPast.setContentDescription(description);
    }

    public void setContentDescriptionArrowFuture(CharSequence description) {
        this.buttonFuture.setContentDescription(description);
    }

    public void setContentDescriptionCalendar(CharSequence description) {
        this.calendarContentDescription = description;
    }

    public CharSequence getCalendarContentDescription() {
        return this.calendarContentDescription != null ? this.calendarContentDescription : this.getContext().getString(R.string.calendar);
    }

    public Drawable getLeftArrowMask() {
        return this.leftArrowMask;
    }

    public void setLeftArrowMask(Drawable icon) {
        this.leftArrowMask = icon;
        this.buttonPast.setImageDrawable(icon);
    }

    public Drawable getRightArrowMask() {
        return this.rightArrowMask;
    }

    public void setRightArrowMask(Drawable icon) {
        this.rightArrowMask = icon;
        this.buttonFuture.setImageDrawable(icon);
    }

    public void setHeaderTextAppearance(int resourceId) {
        this.title.setTextAppearance(this.getContext(), resourceId);
    }

    public void setDateTextAppearance(int resourceId) {
        this.adapter.setDateTextAppearance(resourceId);
    }

    public void setWeekDayTextAppearance(int resourceId) {
        this.adapter.setWeekDayTextAppearance(resourceId);
    }

    public CalendarDay getSelectedDate() {
        List<CalendarDay> dates = this.adapter.getSelectedDates();
        if (dates.isEmpty()) {
            return null;
        }
        return dates.get(dates.size() - 1);
    }

    @NonNull
    public List<CalendarDay> getSelectedDates() {
        return this.adapter.getSelectedDates();
    }

    public void clearSelection() {
        List<CalendarDay> dates = this.getSelectedDates();
        this.adapter.clearSelections();
        for (CalendarDay day : dates) {
            this.dispatchOnDateSelected(day, false);
        }
    }

    public void setSelectedDate(@Nullable Calendar calendar) {
        this.setSelectedDate(CalendarDay.from(calendar));
    }

    public void setSelectedDate(@Nullable Date date) {
        this.setSelectedDate(CalendarDay.from(date));
    }

    public void setSelectedDate(@Nullable CalendarDay date) {
        this.clearSelection();
        if (date != null) {
            this.setDateSelected(date, true);
        }
    }

    public void setDateSelected(@Nullable Calendar calendar, boolean selected) {
        this.setDateSelected(CalendarDay.from(calendar), selected);
    }

    public void setDateSelected(@Nullable Date date, boolean selected) {
        this.setDateSelected(CalendarDay.from(date), selected);
    }

    public void setDateSelected(@Nullable CalendarDay day, boolean selected) {
        if (day == null) {
            return;
        }
        this.adapter.setDateSelected(day, selected);
    }

    public void setCurrentDate(@Nullable Calendar calendar) {
        this.setCurrentDate(CalendarDay.from(calendar));
    }

    public void setCurrentDate(@Nullable Date date) {
        this.setCurrentDate(CalendarDay.from(date));
    }

    public CalendarDay getCurrentDate() {
        return this.adapter.getItem(this.pager.getCurrentItem());
    }

    public void setCurrentDate(@Nullable CalendarDay day) {
        this.setCurrentDate(day, true);
    }

    public void setCurrentDate(@Nullable CalendarDay day, boolean useSmoothScroll) {
        if (day == null) {
            return;
        }
        int index = this.adapter.getIndexForDay(day);
        this.pager.setCurrentItem(index, useSmoothScroll);
        this.updateUi();
    }

    public CalendarDay getMinimumDate() {
        return this.minDate;
    }

    public void setMinimumDate(@Nullable Calendar calendar) {
        this.setMinimumDate(CalendarDay.from(calendar));
    }

    public void setMinimumDate(@Nullable Date date) {
        this.setMinimumDate(CalendarDay.from(date));
    }

    public void setMinimumDate(@Nullable CalendarDay calendar) {
        this.minDate = calendar;
        this.setRangeDates(this.minDate, this.maxDate);
    }

    public CalendarDay getMaximumDate() {
        return this.maxDate;
    }

    public void setMaximumDate(@Nullable Calendar calendar) {
        this.setMaximumDate(CalendarDay.from(calendar));
    }

    public void setMaximumDate(@Nullable Date date) {
        this.setMaximumDate(CalendarDay.from(date));
    }

    public void setMaximumDate(@Nullable CalendarDay calendar) {
        this.maxDate = calendar;
        this.setRangeDates(this.minDate, this.maxDate);
    }

    public void setShowOtherDates(@ShowOtherDates int showOtherDates) {
        this.adapter.setShowOtherDates(showOtherDates);
    }

    public void setAllowClickDaysOutsideCurrentMonth(boolean enabled) {
        this.allowClickDaysOutsideCurrentMonth = enabled;
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        this.adapter.setWeekDayFormatter(formatter == null ? WeekDayFormatter.DEFAULT : formatter);
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.adapter.setDayFormatter(formatter == null ? DayFormatter.DEFAULT : formatter);
    }

    public void setWeekDayLabels(CharSequence[] weekDayLabels) {
        this.setWeekDayFormatter(new ArrayWeekDayFormatter(weekDayLabels));
    }

    public void setWeekDayLabels(@ArrayRes int arrayRes) {
        this.setWeekDayLabels(this.getResources().getTextArray(arrayRes));
    }

    @ShowOtherDates
    public int getShowOtherDates() {
        return this.adapter.getShowOtherDates();
    }

    public boolean allowClickDaysOutsideCurrentMonth() {
        return this.allowClickDaysOutsideCurrentMonth;
    }

    public void setTitleFormatter(TitleFormatter titleFormatter) {
        if (titleFormatter == null) {
            titleFormatter = DEFAULT_TITLE_FORMATTER;
        }
        this.titleChanger.setTitleFormatter(titleFormatter);
        this.adapter.setTitleFormatter(titleFormatter);
        this.updateUi();
    }

    public void setTitleMonths(CharSequence[] monthLabels) {
        this.setTitleFormatter(new MonthArrayTitleFormatter(monthLabels));
    }

    public void setTitleMonths(@ArrayRes int arrayRes) {
        this.setTitleMonths(this.getResources().getTextArray(arrayRes));
    }

    public void setTopbarVisible(boolean visible) {
        this.topbar.setVisibility(visible ? 0 : 8);
        this.requestLayout();
    }

    public boolean getTopbarVisible() {
        return this.topbar.getVisibility() == 0;
    }

    protected Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.color = this.getSelectionColor();
        ss.dateTextAppearance = this.adapter.getDateTextAppearance();
        ss.weekDayTextAppearance = this.adapter.getWeekDayTextAppearance();
        ss.showOtherDates = this.getShowOtherDates();
        ss.allowClickDaysOutsideCurrentMonth = this.allowClickDaysOutsideCurrentMonth();
        ss.minDate = this.getMinimumDate();
        ss.maxDate = this.getMaximumDate();
        ss.selectedDates = this.getSelectedDates();
        ss.firstDayOfWeek = this.getFirstDayOfWeek();
        ss.selectionMode = this.getSelectionMode();
        ss.tileWidthPx = this.getTileWidth();
        ss.tileHeightPx = this.getTileHeight();
        ss.topbarVisible = this.getTopbarVisible();
        ss.calendarMode = this.calendarMode;
        ss.currentMonth = this.currentMonth;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setSelectionColor(ss.color);
        this.setDateTextAppearance(ss.dateTextAppearance);
        this.setWeekDayTextAppearance(ss.weekDayTextAppearance);
        this.setShowOtherDates(ss.showOtherDates);
        this.setAllowClickDaysOutsideCurrentMonth(ss.allowClickDaysOutsideCurrentMonth);
        this.minDate = ss.minDate;
        this.maxDate = ss.maxDate;
        this.setRangeDates(ss.minDate, ss.maxDate);
        this.clearSelection();
        for (CalendarDay calendarDay : ss.selectedDates) {
            this.setDateSelected(calendarDay, true);
        }
        this.setFirstDayOfWeek(ss.firstDayOfWeek);
        this.setTileWidth(ss.tileWidthPx);
        this.setTileHeight(ss.tileHeightPx);
        this.setTopbarVisible(ss.topbarVisible);
        this.setSelectionMode(ss.selectionMode);
        this.setDynamicHeightEnabled(ss.dynamicHeightEnabled);
        this.setCalendarDisplayMode(ss.calendarMode);
        this.setCurrentDate(ss.currentMonth);
    }

    protected void dispatchSaveInstanceState(@NonNull SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(@NonNull SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private void setRangeDates(CalendarDay min, CalendarDay max) {
        CalendarDay c = this.currentMonth;
        this.adapter.setRangeDates(min, max);
        this.currentMonth = c;
        int position = this.adapter.getIndexForDay(c);
        this.pager.setCurrentItem(position, false);
        this.updateUi();
    }

    private static int getThemeAccentColor(Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }

    public void setFirstDayOfWeek(int day) {
        CalendarPagerAdapter newAdapter;
        this.firstDayOfWeek = day;
        switch (this.calendarMode) {
            case MONTHS: {
                newAdapter = new MonthPagerAdapter(this);
                break;
            }
            case WEEKS: {
                newAdapter = new WeekPagerAdapter(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided display mode which is not yet implemented");
            }
        }
        this.adapter = this.adapter == null ? newAdapter : this.adapter.migrateStateAndReturn(newAdapter);
        this.pager.setAdapter(this.adapter);
        this.setRangeDates(this.minDate, this.maxDate);
        this.setCurrentDate(this.selectionMode == 1 && !this.adapter.getSelectedDates().isEmpty() ? this.adapter.getSelectedDates().get(0) : CalendarDay.today());
        this.invalidateDecorators();
        this.updateUi();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setDynamicHeightEnabled(boolean useDynamicHeight) {
        this.mDynamicHeightEnabled = useDynamicHeight;
    }

    public boolean isDynamicHeightEnabled() {
        return this.mDynamicHeightEnabled;
    }

    public void addDecorators(Collection<? extends DayViewDecorator> decorators) {
        if (decorators == null) {
            return;
        }
        this.dayViewDecorators.addAll(decorators);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void addDecorators(DayViewDecorator ... decorators) {
        this.addDecorators(Arrays.asList(decorators));
    }

    public void addDecorator(DayViewDecorator decorator) {
        if (decorator == null) {
            return;
        }
        this.dayViewDecorators.add(decorator);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void removeDecorators() {
        this.dayViewDecorators.clear();
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void removeDecorator(DayViewDecorator decorator) {
        this.dayViewDecorators.remove(decorator);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void invalidateDecorators() {
        this.adapter.invalidateDecorators();
    }

    public void setOnDateChangedListener(OnDateSelectedListener listener) {
        this.listener = listener;
    }

    public void setOnMonthChangedListener(OnMonthChangedListener listener) {
        this.monthListener = listener;
    }

    protected void dispatchOnDateSelected(CalendarDay day, boolean selected) {
        OnDateSelectedListener l = this.listener;
        if (l != null) {
            l.onDateSelected(this, day, selected);
        }
    }

    protected void dispatchOnMonthChanged(CalendarDay day) {
        OnMonthChangedListener l = this.monthListener;
        if (l != null) {
            l.onMonthChanged(this, day);
        }
    }

    protected void onDateClicked(@NonNull CalendarDay date, boolean nowSelected) {
        switch (this.selectionMode) {
            case 2: {
                this.adapter.setDateSelected(date, nowSelected);
                this.dispatchOnDateSelected(date, nowSelected);
                break;
            }
            default: {
                this.adapter.clearSelections();
                this.adapter.setDateSelected(date, true);
                this.dispatchOnDateSelected(date, true);
            }
        }
    }

    protected void onDateClicked(DayView dayView) {
        int currentMonth = this.getCurrentDate().getMonth();
        int selectedMonth = dayView.getDate().getMonth();
        if (this.calendarMode == CalendarMode.MONTHS) {
            if (this.allowClickDaysOutsideCurrentMonth || currentMonth == selectedMonth) {
                if (currentMonth > selectedMonth) {
                    this.goToPrevious();
                } else if (currentMonth < selectedMonth) {
                    this.goToNext();
                }
                this.onDateClicked(dayView.getDate(), !dayView.isChecked());
            }
        } else {
            this.onDateClicked(dayView.getDate(), !dayView.isChecked());
        }
    }

    protected void onDateUnselected(CalendarDay date) {
        this.dispatchOnDateSelected(date, false);
    }

    public static boolean showOtherMonths(@ShowOtherDates int showOtherDates) {
        return (showOtherDates & 1) != 0;
    }

    public static boolean showOutOfRange(@ShowOtherDates int showOtherDates) {
        return (showOtherDates & 2) != 0;
    }

    public static boolean showDecoratedDisabled(@ShowOtherDates int showOtherDates) {
        return (showOtherDates & 4) != 0;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int specHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int desiredWidth = specWidthSize - this.getPaddingLeft() - this.getPaddingRight();
        int desiredHeight = specHeightSize - this.getPaddingTop() - this.getPaddingBottom();
        int weekCount = this.getWeekCountBasedOnMode();
        int viewTileHeight = this.getTopbarVisible() ? weekCount + 1 : weekCount;
        int desiredTileWidth = desiredWidth / 7;
        int desiredTileHeight = desiredHeight / viewTileHeight;
        int measureTileSize = -1;
        int measureTileWidth = -1;
        int measureTileHeight = -1;
        if (this.tileWidth > 0 || this.tileHeight > 0) {
            if (this.tileWidth > 0) {
                measureTileWidth = this.tileWidth;
            }
            if (this.tileHeight > 0) {
                measureTileHeight = this.tileHeight;
            }
        } else if (specWidthMode == 0x40000000) {
            measureTileSize = specHeightMode == 0x40000000 ? Math.max(desiredTileWidth, desiredTileHeight) : desiredTileWidth;
        } else if (specHeightMode == 0x40000000) {
            measureTileSize = desiredTileHeight;
        }
        if (measureTileSize > 0) {
            measureTileHeight = measureTileSize;
            measureTileWidth = measureTileSize;
        } else if (measureTileSize <= 0) {
            if (measureTileWidth <= 0) {
                measureTileWidth = this.dpToPx(44);
            }
            if (measureTileHeight <= 0) {
                measureTileHeight = this.dpToPx(44);
            }
        }
        int measuredWidth = measureTileWidth * 7;
        int measuredHeight = measureTileHeight * viewTileHeight;
        this.setMeasuredDimension(MaterialCalendarView.clampSize(measuredWidth += this.getPaddingLeft() + this.getPaddingRight(), widthMeasureSpec), MaterialCalendarView.clampSize(measuredHeight += this.getPaddingTop() + this.getPaddingBottom(), heightMeasureSpec));
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams p = (LayoutParams)child.getLayoutParams();
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(7 * measureTileWidth), (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(p.height * measureTileHeight), (int)0x40000000);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    private int getWeekCountBasedOnMode() {
        int weekCount = this.calendarMode.visibleWeeksCount;
        boolean isInMonthsMode = this.calendarMode.equals((Object)CalendarMode.MONTHS);
        if (isInMonthsMode && this.mDynamicHeightEnabled && this.adapter != null && this.pager != null) {
            Calendar cal = (Calendar)this.adapter.getItem(this.pager.getCurrentItem()).getCalendar().clone();
            cal.set(5, cal.getActualMaximum(5));
            cal.setFirstDayOfWeek(this.getFirstDayOfWeek());
            weekCount = cal.get(4);
        }
        return weekCount + 1;
    }

    private static int clampSize(int size, int spec) {
        int specMode = View.MeasureSpec.getMode((int)spec);
        int specSize = View.MeasureSpec.getSize((int)spec);
        switch (specMode) {
            case 0x40000000: {
                return specSize;
            }
            case -2147483648: {
                return Math.min(size, specSize);
            }
        }
        return size;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft();
        int parentWidth = right - left - parentLeft - this.getPaddingRight();
        int childTop = this.getPaddingTop();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int delta = (parentWidth - width) / 2;
            int childLeft = parentLeft + delta;
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
            childTop += height;
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(1);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(1);
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)MaterialCalendarView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)MaterialCalendarView.class.getName());
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.pager.setPagingEnabled(pagingEnabled);
        this.updateUi();
    }

    public boolean isPagingEnabled() {
        return this.pager.isPagingEnabled();
    }

    protected static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(int tileHeight) {
            super(-1, tileHeight);
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int color = 0;
        int dateTextAppearance = 0;
        int weekDayTextAppearance = 0;
        int showOtherDates = 4;
        boolean allowClickDaysOutsideCurrentMonth = true;
        CalendarDay minDate = null;
        CalendarDay maxDate = null;
        List<CalendarDay> selectedDates = new ArrayList<CalendarDay>();
        int firstDayOfWeek = 1;
        int tileWidthPx = -1;
        int tileHeightPx = -1;
        boolean topbarVisible = true;
        int selectionMode = 1;
        boolean dynamicHeightEnabled = false;
        CalendarMode calendarMode = CalendarMode.MONTHS;
        CalendarDay currentMonth = null;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.color);
            out.writeInt(this.dateTextAppearance);
            out.writeInt(this.weekDayTextAppearance);
            out.writeInt(this.showOtherDates);
            out.writeByte((byte)(this.allowClickDaysOutsideCurrentMonth ? 1 : 0));
            out.writeParcelable((Parcelable)this.minDate, 0);
            out.writeParcelable((Parcelable)this.maxDate, 0);
            out.writeTypedList(this.selectedDates);
            out.writeInt(this.firstDayOfWeek);
            out.writeInt(this.tileWidthPx);
            out.writeInt(this.tileHeightPx);
            out.writeInt(this.topbarVisible ? 1 : 0);
            out.writeInt(this.selectionMode);
            out.writeInt(this.dynamicHeightEnabled ? 1 : 0);
            out.writeInt(this.calendarMode == CalendarMode.WEEKS ? 1 : 0);
            out.writeParcelable((Parcelable)this.currentMonth, 0);
        }

        private SavedState(Parcel in) {
            super(in);
            this.color = in.readInt();
            this.dateTextAppearance = in.readInt();
            this.weekDayTextAppearance = in.readInt();
            this.showOtherDates = in.readInt();
            this.allowClickDaysOutsideCurrentMonth = in.readByte() != 0;
            ClassLoader loader = CalendarDay.class.getClassLoader();
            this.minDate = (CalendarDay)in.readParcelable(loader);
            this.maxDate = (CalendarDay)in.readParcelable(loader);
            in.readTypedList(this.selectedDates, CalendarDay.CREATOR);
            this.firstDayOfWeek = in.readInt();
            this.tileWidthPx = in.readInt();
            this.tileHeightPx = in.readInt();
            this.topbarVisible = in.readInt() == 1;
            this.selectionMode = in.readInt();
            this.dynamicHeightEnabled = in.readInt() == 1;
            this.calendarMode = in.readInt() == 1 ? CalendarMode.WEEKS : CalendarMode.MONTHS;
            this.currentMonth = (CalendarDay)in.readParcelable(loader);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SuppressLint(value={"UniqueConstants"})
    public static @interface ShowOtherDates {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SelectionMode {
    }
}

