/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.DirectionButton;
import com.prolificinteractive.materialcalendarview.MonthView;
import com.prolificinteractive.materialcalendarview.OnDateChangedListener;
import com.prolificinteractive.materialcalendarview.OnMonthChangedListener;
import com.prolificinteractive.materialcalendarview.R;
import com.prolificinteractive.materialcalendarview.TitleChanger;
import com.prolificinteractive.materialcalendarview.format.ArrayWeekDayFormatter;
import com.prolificinteractive.materialcalendarview.format.DateFormatTitleFormatter;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.MonthArrayTitleFormatter;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class MaterialCalendarView
extends FrameLayout {
    public static final int DEFAULT_TILE_SIZE_DP = 44;
    private static final TitleFormatter DEFAULT_TITLE_FORMATTER = new DateFormatTitleFormatter();
    private final TitleChanger titleChanger;
    private final TextView title;
    private final DirectionButton buttonPast;
    private final DirectionButton buttonFuture;
    private final ViewPager pager;
    private final MonthPagerAdapter adapter;
    private CalendarDay currentMonth;
    private LinearLayout topbar;
    private final ArrayList<DayViewDecorator> dayViewDecorators = new ArrayList();
    private final MonthView.Callbacks monthViewCallbacks = new MonthView.Callbacks(){

        @Override
        public void onDateChanged(CalendarDay date) {
            MaterialCalendarView.this.setSelectedDate(date);
            if (MaterialCalendarView.this.listener != null) {
                MaterialCalendarView.this.listener.onDateChanged(MaterialCalendarView.this, date);
            }
        }
    };
    private final View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v == MaterialCalendarView.this.buttonFuture) {
                MaterialCalendarView.this.pager.setCurrentItem(MaterialCalendarView.this.pager.getCurrentItem() + 1, true);
            } else if (v == MaterialCalendarView.this.buttonPast) {
                MaterialCalendarView.this.pager.setCurrentItem(MaterialCalendarView.this.pager.getCurrentItem() - 1, true);
            }
        }
    };
    private final ViewPager.OnPageChangeListener pageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageSelected(int position) {
            MaterialCalendarView.this.titleChanger.setPreviousMonth(MaterialCalendarView.this.currentMonth);
            MaterialCalendarView.this.currentMonth = MaterialCalendarView.this.adapter.getItem(position);
            MaterialCalendarView.this.updateUi();
            if (MaterialCalendarView.this.monthListener != null) {
                MaterialCalendarView.this.monthListener.onMonthChanged(MaterialCalendarView.this, MaterialCalendarView.this.currentMonth);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }
    };
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private OnDateChangedListener listener;
    private OnMonthChangedListener monthListener;
    private int accentColor = 0;
    private int arrowColor = -16777216;
    private Drawable leftArrowMask;
    private Drawable rightArrowMask;
    private LinearLayout root;

    public MaterialCalendarView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterialCalendarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.buttonPast = new DirectionButton(this.getContext());
        this.title = new TextView(this.getContext());
        this.buttonFuture = new DirectionButton(this.getContext());
        this.pager = new ViewPager(this.getContext());
        this.setupChildren();
        this.title.setOnClickListener(this.onClickListener);
        this.buttonPast.setOnClickListener(this.onClickListener);
        this.buttonFuture.setOnClickListener(this.onClickListener);
        this.titleChanger = new TitleChanger(this.title);
        this.titleChanger.setTitleFormatter(DEFAULT_TITLE_FORMATTER);
        this.adapter = new MonthPagerAdapter(this);
        this.pager.setAdapter((PagerAdapter)this.adapter);
        this.pager.setOnPageChangeListener(this.pageChangeListener);
        this.pager.setPageTransformer(false, new ViewPager.PageTransformer(){

            public void transformPage(View page, float position) {
                position = (float)Math.sqrt(1.0f - Math.abs(position));
                page.setAlpha(position);
            }
        });
        this.adapter.setCallbacks(this.monthViewCallbacks);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaterialCalendarView, 0, 0);
        try {
            int tileSize = a.getDimensionPixelSize(R.styleable.MaterialCalendarView_mcv_tileSize, -1);
            if (tileSize > 0) {
                this.setTileSize(tileSize);
            }
            this.setArrowColor(a.getColor(R.styleable.MaterialCalendarView_mcv_arrowColor, -16777216));
            Drawable leftMask = a.getDrawable(R.styleable.MaterialCalendarView_mcv_leftArrowMask);
            if (leftMask == null) {
                leftMask = this.getResources().getDrawable(R.drawable.mcv_action_previous);
            }
            this.setLeftArrowMask(leftMask);
            Drawable rightMask = a.getDrawable(R.styleable.MaterialCalendarView_mcv_rightArrowMask);
            if (rightMask == null) {
                rightMask = this.getResources().getDrawable(R.drawable.mcv_action_next);
            }
            this.setRightArrowMask(rightMask);
            this.setSelectionColor(a.getColor(R.styleable.MaterialCalendarView_mcv_selectionColor, MaterialCalendarView.getThemeAccentColor(context)));
            CharSequence[] array = a.getTextArray(R.styleable.MaterialCalendarView_mcv_weekDayLabels);
            if (array != null) {
                this.setWeekDayFormatter(new ArrayWeekDayFormatter(array));
            }
            if ((array = a.getTextArray(R.styleable.MaterialCalendarView_mcv_monthLabels)) != null) {
                this.setTitleFormatter(new MonthArrayTitleFormatter(array));
            }
            this.setHeaderTextAppearance(a.getResourceId(R.styleable.MaterialCalendarView_mcv_headerTextAppearance, R.style.TextAppearance_MaterialCalendarWidget_Header));
            this.setWeekDayTextAppearance(a.getResourceId(R.styleable.MaterialCalendarView_mcv_weekDayTextAppearance, R.style.TextAppearance_MaterialCalendarWidget_WeekDay));
            this.setDateTextAppearance(a.getResourceId(R.styleable.MaterialCalendarView_mcv_dateTextAppearance, R.style.TextAppearance_MaterialCalendarWidget_Date));
            this.setShowOtherDates(a.getBoolean(R.styleable.MaterialCalendarView_mcv_showOtherDates, false));
            this.setFirstDayOfWeek(a.getInt(R.styleable.MaterialCalendarView_mcv_firstDayOfWeek, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            a.recycle();
        }
        this.currentMonth = CalendarDay.today();
        this.setCurrentDate(this.currentMonth);
    }

    private void setupChildren() {
        int tileSize = (int)TypedValue.applyDimension((int)1, (float)44.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.root = new LinearLayout(this.getContext());
        this.root.setOrientation(1);
        this.root.setClipChildren(false);
        this.root.setClipToPadding(false);
        FrameLayout.LayoutParams p = new FrameLayout.LayoutParams(tileSize * 7, tileSize * 8);
        p.gravity = 17;
        this.addView((View)this.root, (ViewGroup.LayoutParams)p);
        this.topbar = new LinearLayout(this.getContext());
        this.topbar.setOrientation(0);
        this.topbar.setClipChildren(false);
        this.topbar.setClipToPadding(false);
        this.root.addView((View)this.topbar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        this.buttonPast.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.buttonPast.setImageResource(R.drawable.mcv_action_previous);
        this.topbar.addView((View)this.buttonPast, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        this.title.setGravity(17);
        this.topbar.addView((View)this.title, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 5.0f));
        this.buttonFuture.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.buttonFuture.setImageResource(R.drawable.mcv_action_next);
        this.topbar.addView((View)this.buttonFuture, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        this.pager.setId(R.id.mcv_pager);
        this.pager.setOffscreenPageLimit(1);
        this.root.addView((View)this.pager, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 7.0f));
    }

    public void setOnDateChangedListener(OnDateChangedListener listener) {
        this.listener = listener;
    }

    public void setOnMonthChangedListener(OnMonthChangedListener listener) {
        this.monthListener = listener;
    }

    private void updateUi() {
        this.titleChanger.change(this.currentMonth);
        this.buttonPast.setEnabled(this.canGoBack());
        this.buttonFuture.setEnabled(this.canGoForward());
    }

    public void setTileSize(int size) {
        FrameLayout.LayoutParams p = new FrameLayout.LayoutParams(size * 7, size * 8);
        p.gravity = 17;
        this.root.setLayoutParams((ViewGroup.LayoutParams)p);
    }

    public void setTileSizeDp(int tileSizeDp) {
        this.setTileSize((int)TypedValue.applyDimension((int)1, (float)tileSizeDp, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    private boolean canGoForward() {
        return this.pager.getCurrentItem() < this.adapter.getCount() - 1;
    }

    private boolean canGoBack() {
        return this.pager.getCurrentItem() > 0;
    }

    public int getSelectionColor() {
        return this.accentColor;
    }

    public void setSelectionColor(int color) {
        if (color == 0) {
            return;
        }
        this.accentColor = color;
        this.adapter.setSelectionColor(color);
        this.invalidate();
    }

    public int getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(int color) {
        if (color == 0) {
            return;
        }
        this.arrowColor = color;
        this.buttonPast.setColor(color);
        this.buttonFuture.setColor(color);
        this.invalidate();
    }

    public Drawable getLeftArrowMask() {
        return this.leftArrowMask;
    }

    public void setLeftArrowMask(Drawable icon) {
        this.leftArrowMask = icon;
        this.buttonPast.setImageDrawable(icon);
    }

    public Drawable getRightArrowMask() {
        return this.rightArrowMask;
    }

    public void setRightArrowMask(Drawable icon) {
        this.rightArrowMask = icon;
        this.buttonFuture.setImageDrawable(icon);
    }

    public void setHeaderTextAppearance(int resourceId) {
        this.title.setTextAppearance(this.getContext(), resourceId);
    }

    public void setDateTextAppearance(int resourceId) {
        this.adapter.setDateTextAppearance(resourceId);
    }

    public void setWeekDayTextAppearance(int resourceId) {
        this.adapter.setWeekDayTextAppearance(resourceId);
    }

    public CalendarDay getSelectedDate() {
        return this.adapter.getSelectedDate();
    }

    public void clearSelection() {
        this.setSelectedDate((CalendarDay)null);
    }

    public void setSelectedDate(@Nullable Calendar calendar) {
        this.setSelectedDate(CalendarDay.from(calendar));
    }

    public void setSelectedDate(@Nullable Date date) {
        this.setSelectedDate(CalendarDay.from(date));
    }

    public void setSelectedDate(@Nullable CalendarDay day) {
        this.adapter.setSelectedDate(day);
        this.setCurrentDate(day);
    }

    public void setCurrentDate(@Nullable Calendar calendar) {
        this.setCurrentDate(CalendarDay.from(calendar));
    }

    public void setCurrentDate(@Nullable Date date) {
        this.setCurrentDate(CalendarDay.from(date));
    }

    public CalendarDay getCurrentDate() {
        return this.adapter.getItem(this.pager.getCurrentItem());
    }

    public void setCurrentDate(@Nullable CalendarDay day) {
        if (day == null) {
            return;
        }
        int index = this.adapter.getIndexForDay(day);
        this.pager.setCurrentItem(index);
        this.updateUi();
    }

    public CalendarDay getMinimumDate() {
        return this.minDate;
    }

    public void setMinimumDate(@Nullable Calendar calendar) {
        this.setMinimumDate(CalendarDay.from(calendar));
    }

    public void setMinimumDate(@Nullable Date date) {
        this.setMinimumDate(CalendarDay.from(date));
    }

    public void setMinimumDate(@Nullable CalendarDay calendar) {
        this.minDate = calendar;
        this.setRangeDates(this.minDate, this.maxDate);
    }

    public CalendarDay getMaximumDate() {
        return this.maxDate;
    }

    public void setMaximumDate(@Nullable Calendar calendar) {
        this.setMaximumDate(CalendarDay.from(calendar));
    }

    public void setMaximumDate(@Nullable Date date) {
        this.setMaximumDate(CalendarDay.from(date));
    }

    public void setMaximumDate(@Nullable CalendarDay calendar) {
        this.maxDate = calendar;
        this.setRangeDates(this.minDate, this.maxDate);
    }

    public void setShowOtherDates(boolean showOtherDates) {
        this.adapter.setShowOtherDates(showOtherDates);
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        this.adapter.setWeekDayFormatter(formatter == null ? WeekDayFormatter.DEFAULT : formatter);
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.adapter.setDayFormatter(formatter == null ? DayFormatter.DEFAULT : formatter);
    }

    public void setWeekDayLabels(CharSequence[] weekDayLabels) {
        this.setWeekDayFormatter(new ArrayWeekDayFormatter(weekDayLabels));
    }

    public void setWeekDayLabels(@ArrayRes int arrayRes) {
        this.setWeekDayLabels(this.getResources().getTextArray(arrayRes));
    }

    public boolean getShowOtherDates() {
        return this.adapter.getShowOtherDates();
    }

    public void setTitleFormatter(TitleFormatter titleFormatter) {
        this.titleChanger.setTitleFormatter(titleFormatter == null ? DEFAULT_TITLE_FORMATTER : titleFormatter);
        this.updateUi();
    }

    public void setTitleMonths(CharSequence[] monthLabels) {
        this.setTitleFormatter(new MonthArrayTitleFormatter(monthLabels));
    }

    public void setTitleMonths(@ArrayRes int arrayRes) {
        this.setTitleMonths(this.getResources().getTextArray(arrayRes));
    }

    public void setTopbarVisible(boolean visible) {
        if (visible) {
            this.topbar.setVisibility(0);
        } else {
            this.topbar.setVisibility(8);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.color = this.getSelectionColor();
        ss.dateTextAppearance = this.adapter.getDateTextAppearance();
        ss.weekDayTextAppearance = this.adapter.getWeekDayTextAppearance();
        ss.showOtherDates = this.getShowOtherDates();
        ss.minDate = this.getMinimumDate();
        ss.maxDate = this.getMaximumDate();
        ss.selectedDate = this.getSelectedDate();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setSelectionColor(ss.color);
        this.setDateTextAppearance(ss.dateTextAppearance);
        this.setWeekDayTextAppearance(ss.weekDayTextAppearance);
        this.setShowOtherDates(ss.showOtherDates);
        this.setRangeDates(ss.minDate, ss.maxDate);
        this.setSelectedDate(ss.selectedDate);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        super.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchThawSelfOnly(container);
    }

    private void setRangeDates(CalendarDay min, CalendarDay max) {
        CalendarDay c = this.currentMonth;
        this.adapter.setRangeDates(min, max);
        this.currentMonth = c;
        int position = this.adapter.getIndexForDay(c);
        this.pager.setCurrentItem(position, false);
    }

    private static int getThemeAccentColor(Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }

    public void setFirstDayOfWeek(int day) {
        this.adapter.setFirstDayOfWeek(day);
    }

    public int getFirstDayOfWeek() {
        return this.adapter.getFirstDayOfWeek();
    }

    public void addDecorators(Collection<? extends DayViewDecorator> decorators) {
        if (decorators == null) {
            return;
        }
        this.dayViewDecorators.addAll(decorators);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void addDecorators(DayViewDecorator ... decorators) {
        this.addDecorators(Arrays.asList(decorators));
    }

    public void addDecorator(DayViewDecorator decorator) {
        if (decorator == null) {
            return;
        }
        this.dayViewDecorators.add(decorator);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void removeDecorators() {
        this.dayViewDecorators.clear();
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void removeDecorator(DayViewDecorator decorator) {
        this.dayViewDecorators.remove(decorator);
        this.adapter.setDecorators(this.dayViewDecorators);
    }

    public void invalidateDecorators() {
        this.adapter.invalidateDecorators();
    }

    private static class MonthPagerAdapter
    extends PagerAdapter {
        private final MaterialCalendarView view;
        private final LinkedList<MonthView> currentViews;
        private final ArrayList<CalendarDay> months;
        private MonthView.Callbacks callbacks = null;
        private Integer color = null;
        private Integer dateTextAppearance = null;
        private Integer weekDayTextAppearance = null;
        private Boolean showOtherDates = null;
        private CalendarDay minDate = null;
        private CalendarDay maxDate = null;
        private CalendarDay selectedDate = null;
        private WeekDayFormatter weekDayFormatter = WeekDayFormatter.DEFAULT;
        private DayFormatter dayFormatter = DayFormatter.DEFAULT;
        private List<DayViewDecorator> decorators = null;
        private List<DecoratorResult> decoratorResults = null;
        private int firstDayOfTheWeek = 1;

        private MonthPagerAdapter(MaterialCalendarView view) {
            this.view = view;
            this.currentViews = new LinkedList();
            this.months = new ArrayList();
            this.setRangeDates(null, null);
        }

        public void setDecorators(List<DayViewDecorator> decorators) {
            this.decorators = decorators;
            this.invalidateDecorators();
        }

        public void invalidateDecorators() {
            this.decoratorResults = new ArrayList<DecoratorResult>();
            for (DayViewDecorator decorator : this.decorators) {
                DayViewFacade facade = new DayViewFacade();
                decorator.decorate(facade);
                if (!facade.isDecorated()) continue;
                this.decoratorResults.add(new DecoratorResult(decorator, facade));
            }
            for (MonthView monthView : this.currentViews) {
                monthView.setDayViewDecorators(this.decoratorResults);
            }
        }

        public int getCount() {
            return this.months.size();
        }

        public int getIndexForDay(CalendarDay day) {
            if (day == null) {
                return this.getCount() / 2;
            }
            if (this.minDate != null && day.isBefore(this.minDate)) {
                return 0;
            }
            if (this.maxDate != null && day.isAfter(this.maxDate)) {
                return this.getCount() - 1;
            }
            for (int i = 0; i < this.months.size(); ++i) {
                CalendarDay month = this.months.get(i);
                if (day.getYear() != month.getYear() || day.getMonth() != month.getMonth()) continue;
                return i;
            }
            return this.getCount() / 2;
        }

        public int getItemPosition(Object object) {
            if (!(object instanceof MonthView)) {
                return -2;
            }
            MonthView monthView = (MonthView)((Object)object);
            CalendarDay month = monthView.getMonth();
            if (month == null) {
                return -2;
            }
            int index = this.months.indexOf(month);
            if (index < 0) {
                return -2;
            }
            return index;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            CalendarDay month = this.months.get(position);
            MonthView monthView = new MonthView(container.getContext(), month, this.firstDayOfTheWeek);
            monthView.setWeekDayFormatter(this.weekDayFormatter);
            monthView.setDayFormatter(this.dayFormatter);
            monthView.setCallbacks(this.callbacks);
            if (this.color != null) {
                monthView.setSelectionColor(this.color);
            }
            if (this.dateTextAppearance != null) {
                monthView.setDateTextAppearance(this.dateTextAppearance);
            }
            if (this.weekDayTextAppearance != null) {
                monthView.setWeekDayTextAppearance(this.weekDayTextAppearance);
            }
            if (this.showOtherDates != null) {
                monthView.setShowOtherDates(this.showOtherDates);
            }
            monthView.setMinimumDate(this.minDate);
            monthView.setMaximumDate(this.maxDate);
            monthView.setSelectedDate(this.selectedDate);
            container.addView((View)monthView);
            this.currentViews.add(monthView);
            monthView.setDayViewDecorators(this.decoratorResults);
            return monthView;
        }

        public void setFirstDayOfWeek(int day) {
            this.firstDayOfTheWeek = day;
            for (MonthView monthView : this.currentViews) {
                monthView.setFirstDayOfWeek(this.firstDayOfTheWeek);
            }
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            MonthView monthView = (MonthView)((Object)object);
            this.currentViews.remove((Object)monthView);
            container.removeView((View)monthView);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public void setCallbacks(MonthView.Callbacks callbacks) {
            this.callbacks = callbacks;
            for (MonthView monthView : this.currentViews) {
                monthView.setCallbacks(callbacks);
            }
        }

        public void setSelectionColor(int color) {
            this.color = color;
            for (MonthView monthView : this.currentViews) {
                monthView.setSelectionColor(color);
            }
        }

        public void setDateTextAppearance(int taId) {
            if (taId == 0) {
                return;
            }
            this.dateTextAppearance = taId;
            for (MonthView monthView : this.currentViews) {
                monthView.setDateTextAppearance(taId);
            }
        }

        public void setShowOtherDates(boolean show) {
            this.showOtherDates = show;
            for (MonthView monthView : this.currentViews) {
                monthView.setShowOtherDates(show);
            }
        }

        public void setWeekDayFormatter(WeekDayFormatter formatter) {
            this.weekDayFormatter = formatter;
            for (MonthView monthView : this.currentViews) {
                monthView.setWeekDayFormatter(formatter);
            }
        }

        public void setDayFormatter(DayFormatter formatter) {
            this.dayFormatter = formatter;
            for (MonthView monthView : this.currentViews) {
                monthView.setDayFormatter(formatter);
            }
        }

        public boolean getShowOtherDates() {
            return this.showOtherDates;
        }

        public void setWeekDayTextAppearance(int taId) {
            if (taId == 0) {
                return;
            }
            this.weekDayTextAppearance = taId;
            for (MonthView monthView : this.currentViews) {
                monthView.setWeekDayTextAppearance(taId);
            }
        }

        public void setRangeDates(CalendarDay min, CalendarDay max) {
            Calendar worker;
            this.minDate = min;
            this.maxDate = max;
            for (MonthView monthView : this.currentViews) {
                monthView.setMinimumDate(min);
                monthView.setMaximumDate(max);
            }
            if (min == null) {
                worker = CalendarUtils.getInstance();
                worker.add(1, -200);
                min = CalendarDay.from(worker);
            }
            if (max == null) {
                worker = CalendarUtils.getInstance();
                worker.add(1, 200);
                max = CalendarDay.from(worker);
            }
            worker = CalendarUtils.getInstance();
            min.copyTo(worker);
            CalendarUtils.setToFirstDay(worker);
            this.months.clear();
            CalendarDay workingMonth = CalendarDay.from(worker);
            while (!max.isBefore(workingMonth)) {
                this.months.add(CalendarDay.from(worker));
                worker.add(2, 1);
                workingMonth = CalendarDay.from(worker);
            }
            CalendarDay prevDate = this.selectedDate;
            this.notifyDataSetChanged();
            this.setSelectedDate(prevDate);
            if (prevDate != null && !prevDate.equals(this.selectedDate)) {
                this.callbacks.onDateChanged(this.selectedDate);
            }
        }

        public void setSelectedDate(@Nullable CalendarDay date) {
            CalendarDay prevDate = this.selectedDate;
            this.selectedDate = this.getValidSelectedDate(date);
            for (MonthView monthView : this.currentViews) {
                monthView.setSelectedDate(this.selectedDate);
            }
            if (date == null && prevDate != null) {
                this.callbacks.onDateChanged(null);
            }
        }

        private CalendarDay getValidSelectedDate(CalendarDay date) {
            if (date == null) {
                return null;
            }
            if (this.minDate != null && this.minDate.isAfter(date)) {
                return this.minDate;
            }
            if (this.maxDate != null && this.maxDate.isBefore(date)) {
                return this.maxDate;
            }
            return date;
        }

        public CalendarDay getItem(int position) {
            return this.months.get(position);
        }

        public CalendarDay getSelectedDate() {
            return this.selectedDate;
        }

        protected int getDateTextAppearance() {
            return this.dateTextAppearance == null ? 0 : this.dateTextAppearance;
        }

        protected int getWeekDayTextAppearance() {
            return this.weekDayTextAppearance == null ? 0 : this.weekDayTextAppearance;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfTheWeek;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        int color = 0;
        int dateTextAppearance = 0;
        int weekDayTextAppearance = 0;
        boolean showOtherDates = false;
        CalendarDay minDate = null;
        CalendarDay maxDate = null;
        CalendarDay selectedDate = null;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.color);
            out.writeInt(this.dateTextAppearance);
            out.writeInt(this.weekDayTextAppearance);
            out.writeInt(this.showOtherDates ? 1 : 0);
            out.writeParcelable((Parcelable)this.minDate, 0);
            out.writeParcelable((Parcelable)this.maxDate, 0);
            out.writeParcelable((Parcelable)this.selectedDate, 0);
        }

        private SavedState(Parcel in) {
            super(in);
            this.color = in.readInt();
            this.dateTextAppearance = in.readInt();
            this.weekDayTextAppearance = in.readInt();
            this.showOtherDates = in.readInt() == 1;
            ClassLoader loader = CalendarDay.class.getClassLoader();
            this.minDate = (CalendarDay)in.readParcelable(loader);
            this.maxDate = (CalendarDay)in.readParcelable(loader);
            this.selectedDate = (CalendarDay)in.readParcelable(loader);
        }
    }
}

