/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.os.Parcel;
import android.os.Parcelable;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class CalendarDay
implements Parcelable {
    private final int year;
    private final int month;
    private final int day;
    public static final Parcelable.Creator<CalendarDay> CREATOR = new Parcelable.Creator<CalendarDay>(){

        public CalendarDay createFromParcel(Parcel in) {
            return new CalendarDay(in);
        }

        public CalendarDay[] newArray(int size) {
            return new CalendarDay[size];
        }
    };

    public CalendarDay() {
        this(CalendarUtils.getInstance());
    }

    public CalendarDay(Calendar calendar) {
        this(CalendarUtils.getYear(calendar), CalendarUtils.getMonth(calendar), CalendarUtils.getDay(calendar));
    }

    public CalendarDay(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public CalendarDay(Date date) {
        this(CalendarUtils.getInstance(date));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public Calendar getCalendar() {
        Calendar calendar = CalendarUtils.getInstance();
        this.copyTo(calendar);
        return calendar;
    }

    public void copyTo(Calendar calendar) {
        calendar.clear();
        calendar.set(this.year, this.month, this.day);
    }

    public boolean isInRange(CalendarDay minDate, CalendarDay maxDate) {
        return !(minDate != null && minDate.isAfter(this) || maxDate != null && maxDate.isBefore(this));
    }

    public boolean isBefore(CalendarDay other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        return this.year == other.year ? (this.month == other.month ? this.day < other.day : this.month < other.month) : this.year < other.year;
    }

    public boolean isAfter(CalendarDay other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        return this.year == other.year ? (this.month == other.month ? this.day > other.day : this.month > other.month) : this.year > other.year;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDay that = (CalendarDay)o;
        if (this.day != that.day) {
            return false;
        }
        if (this.month != that.month) {
            return false;
        }
        return this.year == that.year;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        return result;
    }

    public String toString() {
        return String.format(Locale.US, "CalendarDay{%d-%d-%d}", this.year, this.month + 1, this.day);
    }

    public CalendarDay(Parcel in) {
        this(in.readInt(), in.readInt(), in.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.year);
        dest.writeInt(this.month);
        dest.writeInt(this.day);
    }
}

