/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.permission.rom;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Method;

public class OppoUtils {
    private static final String TAG = "OppoUtils";

    public static boolean checkFloatWindowPermission(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return OppoUtils.checkOp(context, 24);
        }
        return true;
    }

    @TargetApi(value=19)
    private static boolean checkOp(Context context, int op) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            try {
                Class<AppOpsManager> clazz = AppOpsManager.class;
                Method method = clazz.getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                return 0 == (Integer)method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        } else {
            Log.e((String)TAG, (String)"Below API 19 cannot invoke!");
        }
        return false;
    }

    public static void applyOppoPermission(Fragment fragment) {
        try {
            Intent intent = new Intent();
            ComponentName comp = new ComponentName("com.coloros.safecenter", "com.coloros.safecenter.sysfloatwindow.FloatWindowListActivity");
            intent.setComponent(comp);
            fragment.startActivityForResult(intent, 199);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

