/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.core;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.IBinder;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import com.lzf.easyfloat.anim.AnimatorManager;
import com.lzf.easyfloat.core.FloatingWindowManager;
import com.lzf.easyfloat.core.TouchUtils;
import com.lzf.easyfloat.data.FloatConfig;
import com.lzf.easyfloat.enums.ShowPattern;
import com.lzf.easyfloat.interfaces.OnFloatCallbacks;
import com.lzf.easyfloat.interfaces.OnFloatTouchListener;
import com.lzf.easyfloat.interfaces.OnInvokeView;
import com.lzf.easyfloat.utils.DisplayUtils;
import com.lzf.easyfloat.utils.InputMethodUtils;
import com.lzf.easyfloat.utils.LifecycleUtils;
import com.lzf.easyfloat.utils.Logger;
import com.lzf.easyfloat.widget.ParentFrameLayout;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J\r\u0010(\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020'H\u0002J\u0006\u0010,\u001a\u00020$J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020$H\u0002J\b\u00100\u001a\u00020$H\u0002J\u0010\u00101\u001a\u00020$2\b\b\u0002\u00102\u001a\u000203J\u0012\u00104\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0003J\u0018\u00105\u001a\u00020$2\u0006\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u000203J\u0012\u00109\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006:"}, d2={"Lcom/lzf/easyfloat/core/FloatingWindowHelper;", "", "context", "Landroid/content/Context;", "config", "Lcom/lzf/easyfloat/data/FloatConfig;", "(Landroid/content/Context;Lcom/lzf/easyfloat/data/FloatConfig;)V", "getConfig", "()Lcom/lzf/easyfloat/data/FloatConfig;", "setConfig", "(Lcom/lzf/easyfloat/data/FloatConfig;)V", "getContext", "()Landroid/content/Context;", "enterAnimator", "Landroid/animation/Animator;", "frameLayout", "Lcom/lzf/easyfloat/widget/ParentFrameLayout;", "getFrameLayout", "()Lcom/lzf/easyfloat/widget/ParentFrameLayout;", "setFrameLayout", "(Lcom/lzf/easyfloat/widget/ParentFrameLayout;)V", "params", "Landroid/view/WindowManager$LayoutParams;", "getParams", "()Landroid/view/WindowManager$LayoutParams;", "setParams", "(Landroid/view/WindowManager$LayoutParams;)V", "touchUtils", "Lcom/lzf/easyfloat/core/TouchUtils;", "windowManager", "Landroid/view/WindowManager;", "getWindowManager", "()Landroid/view/WindowManager;", "setWindowManager", "(Landroid/view/WindowManager;)V", "addView", "", "checkEditText", "view", "Landroid/view/View;", "createWindow", "()Lkotlin/Unit;", "enterAnim", "floatingView", "exitAnim", "getToken", "Landroid/os/IBinder;", "initEditText", "initParams", "remove", "force", "", "setGravity", "setVisible", "visible", "", "needShow", "traverseViewGroup", "easyfloat_release"})
public final class FloatingWindowHelper {
    public WindowManager windowManager;
    public WindowManager.LayoutParams params;
    @Nullable
    private ParentFrameLayout frameLayout;
    private TouchUtils touchUtils;
    private Animator enterAnimator;
    @NotNull
    private final Context context;
    @NotNull
    private FloatConfig config;

    @NotNull
    public final WindowManager getWindowManager() {
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        return windowManager;
    }

    public final void setWindowManager(@NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"<set-?>");
        this.windowManager = windowManager;
    }

    @NotNull
    public final WindowManager.LayoutParams getParams() {
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        return layoutParams;
    }

    public final void setParams(@NotNull WindowManager.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"<set-?>");
        this.params = layoutParams;
    }

    @Nullable
    public final ParentFrameLayout getFrameLayout() {
        return this.frameLayout;
    }

    public final void setFrameLayout(@Nullable ParentFrameLayout parentFrameLayout) {
        this.frameLayout = parentFrameLayout;
    }

    @Nullable
    public final Unit createWindow() {
        Unit unit;
        try {
            this.touchUtils = new TouchUtils(this.context, this.config);
            this.initParams();
            this.addView();
            this.config.setShow(true);
            unit = Unit.INSTANCE;
        }
        catch (Exception e) {
            Function3<Boolean, String, View, Unit> function3;
            OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
            if (onFloatCallbacks != null) {
                onFloatCallbacks.createdResult(false, String.valueOf(e), null);
            }
            unit = (function3 = this.config.getFloatCallbacks()) != null && (function3 = function3.getBuilder()) != null && (function3 = function3.getCreatedResult$easyfloat_release()) != null ? (Unit)function3.invoke((Object)false, (Object)String.valueOf(e), null) : null;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final void initParams() {
        void $this$apply;
        Object object = this.context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        this.windowManager = (WindowManager)object;
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        boolean bl = false;
        boolean bl2 = false;
        WindowManager.LayoutParams layoutParams2 = layoutParams;
        FloatingWindowHelper floatingWindowHelper = this;
        boolean bl3 = false;
        if (this.config.getShowPattern() == ShowPattern.CURRENT_ACTIVITY) {
            $this$apply.type = 1000;
            $this$apply.token = this.getToken();
        } else {
            $this$apply.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        }
        $this$apply.format = 1;
        $this$apply.gravity = 0x800033;
        $this$apply.flags = this.config.getImmersionStatusBar() ? 552 : 40;
        $this$apply.width = this.config.getWidthMatch() ? -1 : -2;
        int n = $this$apply.height = this.config.getHeightMatch() ? -1 : -2;
        if (this.config.getImmersionStatusBar() && this.config.getHeightMatch()) {
            $this$apply.height = DisplayUtils.INSTANCE.getScreenSize((Context)this.context).y;
        }
        if (Intrinsics.areEqual(this.config.getLocationPair(), (Object)new Pair((Object)0, (Object)0)) ^ true) {
            $this$apply.x = ((Number)this.config.getLocationPair().getFirst()).intValue();
            $this$apply.y = ((Number)this.config.getLocationPair().getSecond()).intValue();
        }
        Unit unit = Unit.INSTANCE;
        floatingWindowHelper.params = layoutParams;
    }

    private final IBinder getToken() {
        Activity activity = this.context instanceof Activity ? (Activity)this.context : LifecycleUtils.INSTANCE.getTopActivity();
        Activity activity2 = activity;
        return activity2 != null && (activity2 = activity2.getWindow()) != null && (activity2 = activity2.getDecorView()) != null ? activity2.getWindowToken() : null;
    }

    private final void addView() {
        block4: {
            View floatingView;
            ParentFrameLayout parentFrameLayout = this.frameLayout = new ParentFrameLayout(this.context, this.config, null, 0, 12, null);
            if (parentFrameLayout != null) {
                parentFrameLayout.setTag(this.config.getFloatTag());
            }
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
            Integer n = this.config.getLayoutId();
            Intrinsics.checkNotNull((Object)n);
            View view = floatingView = layoutInflater.inflate(n.intValue(), (ViewGroup)this.frameLayout, true);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"floatingView");
            view.setVisibility(4);
            WindowManager windowManager = this.windowManager;
            if (windowManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
            }
            View view2 = (View)this.frameLayout;
            WindowManager.LayoutParams layoutParams = this.params;
            if (layoutParams == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            windowManager.addView(view2, (ViewGroup.LayoutParams)layoutParams);
            ParentFrameLayout parentFrameLayout2 = this.frameLayout;
            if (parentFrameLayout2 != null) {
                parentFrameLayout2.setTouchListener(new OnFloatTouchListener(this){
                    final /* synthetic */ FloatingWindowHelper this$0;

                    public void onTouch(@NotNull MotionEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        TouchUtils touchUtils = FloatingWindowHelper.access$getTouchUtils$p(this.this$0);
                        ParentFrameLayout parentFrameLayout = this.this$0.getFrameLayout();
                        Intrinsics.checkNotNull((Object)((Object)parentFrameLayout));
                        touchUtils.updateFloat((View)parentFrameLayout, event, this.this$0.getWindowManager(), this.this$0.getParams());
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
            }
            ParentFrameLayout parentFrameLayout3 = this.frameLayout;
            if (parentFrameLayout3 == null) break block4;
            parentFrameLayout3.setLayoutListener(new ParentFrameLayout.OnLayoutListener(this, floatingView){
                final /* synthetic */ FloatingWindowHelper this$0;
                final /* synthetic */ View $floatingView;

                public void onLayout() {
                    block4: {
                        Function3<Boolean, String, View, Unit> function3;
                        FloatingWindowHelper.access$setGravity(this.this$0, (View)this.this$0.getFrameLayout());
                        FloatConfig floatConfig = this.this$0.getConfig();
                        boolean bl = false;
                        boolean bl2 = false;
                        FloatConfig $this$apply = floatConfig;
                        boolean bl3 = false;
                        if ($this$apply.getFilterSelf$easyfloat_release() || $this$apply.getShowPattern() == ShowPattern.BACKGROUND && LifecycleUtils.INSTANCE.isForeground() || $this$apply.getShowPattern() == ShowPattern.FOREGROUND && !LifecycleUtils.INSTANCE.isForeground()) {
                            FloatingWindowHelper.setVisible$default(this.this$0, 8, false, 2, null);
                            FloatingWindowHelper.access$initEditText(this.this$0);
                        } else {
                            View view = this.$floatingView;
                            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"floatingView");
                            FloatingWindowHelper.access$enterAnim(this.this$0, view);
                        }
                        $this$apply.setLayoutView(this.$floatingView);
                        OnInvokeView onInvokeView = $this$apply.getInvokeView();
                        if (onInvokeView != null) {
                            onInvokeView.invoke(this.$floatingView);
                        }
                        OnFloatCallbacks onFloatCallbacks = $this$apply.getCallbacks();
                        if (onFloatCallbacks != null) {
                            onFloatCallbacks.createdResult(true, null, this.$floatingView);
                        }
                        if ((function3 = $this$apply.getFloatCallbacks()) == null || (function3 = function3.getBuilder()) == null || (function3 = function3.getCreatedResult$easyfloat_release()) == null) break block4;
                        Unit cfr_ignored_0 = (Unit)function3.invoke((Object)true, null, (Object)this.$floatingView);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$floatingView = $captured_local_variable$1;
                }
            });
        }
    }

    private final void initEditText() {
        block1: {
            if (!this.config.getHasEditText()) break block1;
            ParentFrameLayout parentFrameLayout = this.frameLayout;
            if (parentFrameLayout != null) {
                ParentFrameLayout parentFrameLayout2 = parentFrameLayout;
                boolean bl = false;
                boolean bl2 = false;
                ParentFrameLayout it = parentFrameLayout2;
                boolean bl3 = false;
                this.traverseViewGroup((View)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void traverseViewGroup(View view) {
        block5: {
            View view2 = view;
            if (view2 == null) break block5;
            View view3 = view2;
            boolean bl = false;
            boolean bl2 = false;
            View it = view3;
            boolean bl3 = false;
            if (it instanceof ViewGroup) {
                int n = 0;
                int n2 = ((ViewGroup)it).getChildCount();
                while (n < n2) {
                    void i;
                    View child = ((ViewGroup)it).getChildAt((int)i);
                    if (child instanceof ViewGroup) {
                        this.traverseViewGroup(child);
                    } else {
                        View view4 = child;
                        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"child");
                        this.checkEditText(view4);
                    }
                    ++i;
                }
            } else {
                this.checkEditText(it);
            }
        }
    }

    private final void checkEditText(View view) {
        if (view instanceof EditText) {
            InputMethodUtils.INSTANCE.initInputMethod$easyfloat_release((EditText)view, this.config.getFloatTag());
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private final void setGravity(View view) {
        if (Intrinsics.areEqual(this.config.getLocationPair(), (Object)new Pair((Object)0, (Object)0)) ^ true || view == null) {
            return;
        }
        Rect parentRect = new Rect();
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        windowManager.getDefaultDisplay().getRectSize(parentRect);
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int n = location[1];
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        int statusBarHeight = n > layoutParams.y ? DisplayUtils.INSTANCE.statusBarHeight(view) : 0;
        int parentBottom = this.config.getDisplayHeight().getDisplayRealHeight(this.context) - statusBarHeight;
        switch (this.config.getGravity()) {
            case 5: 
            case 53: 
            case 0x800005: 
            case 8388661: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth();
                break;
            }
            case 80: 
            case 83: 
            case 8388691: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight();
                break;
            }
            case 85: 
            case 0x800055: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth();
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight();
                break;
            }
            case 17: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth() >> 1;
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight() >> 1;
                break;
            }
            case 1: 
            case 49: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth() >> 1;
                break;
            }
            case 81: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth() >> 1;
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight();
                break;
            }
            case 16: 
            case 19: 
            case 8388627: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight() >> 1;
                break;
            }
            case 21: 
            case 8388629: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth();
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight() >> 1;
                break;
            }
        }
        WindowManager.LayoutParams layoutParams2 = this.params;
        if (layoutParams2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        layoutParams2.x += ((Number)this.config.getOffsetPair().getFirst()).intValue();
        WindowManager.LayoutParams layoutParams3 = this.params;
        if (layoutParams3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        layoutParams3.y += ((Number)this.config.getOffsetPair().getSecond()).intValue();
        if (this.config.getImmersionStatusBar()) {
            if (this.config.getShowPattern() != ShowPattern.CURRENT_ACTIVITY) {
                WindowManager.LayoutParams layoutParams4 = this.params;
                if (layoutParams4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                layoutParams4.y -= statusBarHeight;
            }
        } else if (this.config.getShowPattern() == ShowPattern.CURRENT_ACTIVITY) {
            WindowManager.LayoutParams layoutParams5 = this.params;
            if (layoutParams5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            layoutParams5.y += statusBarHeight;
        }
        WindowManager windowManager2 = this.windowManager;
        if (windowManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        WindowManager.LayoutParams layoutParams6 = this.params;
        if (layoutParams6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        windowManager2.updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams6);
    }

    public final void setVisible(int visible, boolean needShow) {
        block9: {
            Function1<View, Unit> function1;
            View view;
            block8: {
                Function1<View, Unit> function12;
                block7: {
                    block6: {
                        if (this.frameLayout == null) break block6;
                        ParentFrameLayout parentFrameLayout = this.frameLayout;
                        Intrinsics.checkNotNull((Object)((Object)parentFrameLayout));
                        if (parentFrameLayout.getChildCount() >= 1) break block7;
                    }
                    return;
                }
                this.config.setNeedShow$easyfloat_release(needShow);
                ParentFrameLayout parentFrameLayout = this.frameLayout;
                Intrinsics.checkNotNull((Object)((Object)parentFrameLayout));
                parentFrameLayout.setVisibility(visible);
                ParentFrameLayout parentFrameLayout2 = this.frameLayout;
                Intrinsics.checkNotNull((Object)((Object)parentFrameLayout2));
                view = parentFrameLayout2.getChildAt(0);
                if (visible != 0) break block8;
                this.config.setShow(true);
                OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
                if (onFloatCallbacks != null) {
                    View view2 = view;
                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
                    onFloatCallbacks.show(view2);
                }
                if ((function12 = this.config.getFloatCallbacks()) == null || (function12 = function12.getBuilder()) == null || (function12 = function12.getShow$easyfloat_release()) == null) break block9;
                View view3 = view;
                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view");
                Unit cfr_ignored_0 = (Unit)function12.invoke((Object)view3);
                break block9;
            }
            this.config.setShow(false);
            OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
            if (onFloatCallbacks != null) {
                View view4 = view;
                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view");
                onFloatCallbacks.hide(view4);
            }
            if ((function1 = this.config.getFloatCallbacks()) == null || (function1 = function1.getBuilder()) == null || (function1 = function1.getHide$easyfloat_release()) == null) break block9;
            View view5 = view;
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"view");
            Unit cfr_ignored_1 = (Unit)function1.invoke((Object)view5);
        }
    }

    public static /* synthetic */ void setVisible$default(FloatingWindowHelper floatingWindowHelper, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        floatingWindowHelper.setVisible(n, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void enterAnim(View floatingView) {
        Animator animator;
        if (this.frameLayout == null || this.config.isAnim()) {
            return;
        }
        FloatingWindowHelper floatingWindowHelper = this;
        ParentFrameLayout parentFrameLayout = this.frameLayout;
        Intrinsics.checkNotNull((Object)((Object)parentFrameLayout));
        View view = (View)parentFrameLayout;
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        Animator animator2 = new AnimatorManager(view, layoutParams, windowManager, this.config).enterAnim();
        if (animator2 != null) {
            void $this$apply;
            Animator animator3 = animator2;
            boolean bl = false;
            boolean bl2 = false;
            Animator animator4 = animator3;
            FloatingWindowHelper floatingWindowHelper2 = floatingWindowHelper;
            boolean bl3 = false;
            if (this.params == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            this.params.flags = 552;
            $this$apply.addListener(new Animator.AnimatorListener(this, floatingView){
                final /* synthetic */ FloatingWindowHelper this$0;
                final /* synthetic */ View $floatingView$inlined;
                {
                    this.this$0 = floatingWindowHelper;
                    this.$floatingView$inlined = view;
                }

                public void onAnimationRepeat(@Nullable Animator animation) {
                }

                public void onAnimationEnd(@Nullable Animator animation) {
                    this.this$0.getConfig().setAnim(false);
                    if (!this.this$0.getConfig().getImmersionStatusBar()) {
                        this.this$0.getParams().flags = 40;
                    }
                    FloatingWindowHelper.access$initEditText(this.this$0);
                }

                public void onAnimationCancel(@Nullable Animator animation) {
                }

                public void onAnimationStart(@Nullable Animator animation) {
                    this.$floatingView$inlined.setVisibility(0);
                    this.this$0.getConfig().setAnim(true);
                }
            });
            $this$apply.start();
            Unit unit = Unit.INSTANCE;
            floatingWindowHelper = floatingWindowHelper2;
            animator = animator3;
        } else {
            animator = floatingWindowHelper.enterAnimator = null;
        }
        if (this.enterAnimator == null) {
            floatingView.setVisibility(0);
            WindowManager windowManager2 = this.windowManager;
            if (windowManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
            }
            WindowManager.LayoutParams layoutParams2 = this.params;
            if (layoutParams2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            windowManager2.updateViewLayout(floatingView, (ViewGroup.LayoutParams)layoutParams2);
        }
    }

    public final void exitAnim() {
        Animator animator;
        if (this.frameLayout == null || this.config.isAnim() && this.enterAnimator == null) {
            return;
        }
        Animator animator2 = this.enterAnimator;
        if (animator2 != null) {
            animator2.cancel();
        }
        ParentFrameLayout parentFrameLayout = this.frameLayout;
        Intrinsics.checkNotNull((Object)((Object)parentFrameLayout));
        View view = (View)parentFrameLayout;
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        if ((animator = new AnimatorManager(view, layoutParams, windowManager, this.config).exitAnim()) == null) {
            FloatingWindowHelper.remove$default(this, false, 1, null);
        } else {
            if (this.config.isAnim()) {
                return;
            }
            this.config.setAnim(true);
            if (this.params == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            this.params.flags = 552;
            animator.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ FloatingWindowHelper this$0;

                public void onAnimationRepeat(@Nullable Animator animation) {
                }

                public void onAnimationEnd(@Nullable Animator animation) {
                    FloatingWindowHelper.remove$default(this.this$0, false, 1, null);
                }

                public void onAnimationCancel(@Nullable Animator animation) {
                }

                public void onAnimationStart(@Nullable Animator animation) {
                }
                {
                    this.this$0 = this$0;
                }
            });
            animator.start();
        }
    }

    public final void remove(boolean force) {
        try {
            this.config.setAnim(false);
            FloatingWindowManager.INSTANCE.remove(this.config.getFloatTag());
            WindowManager windowManager = this.windowManager;
            if (windowManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
            }
            WindowManager windowManager2 = windowManager;
            boolean bl = false;
            boolean bl2 = false;
            WindowManager $this$run = windowManager2;
            boolean bl3 = false;
            if (force) {
                $this$run.removeViewImmediate((View)this.frameLayout);
            } else {
                $this$run.removeView((View)this.frameLayout);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e("\u6d6e\u7a97\u5173\u95ed\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    public static /* synthetic */ void remove$default(FloatingWindowHelper floatingWindowHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        floatingWindowHelper.remove(bl);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final FloatConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull FloatConfig floatConfig) {
        Intrinsics.checkNotNullParameter((Object)floatConfig, (String)"<set-?>");
        this.config = floatConfig;
    }

    public FloatingWindowHelper(@NotNull Context context, @NotNull FloatConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }

    public static final /* synthetic */ TouchUtils access$getTouchUtils$p(FloatingWindowHelper $this) {
        TouchUtils touchUtils = $this.touchUtils;
        if (touchUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchUtils");
        }
        return touchUtils;
    }

    public static final /* synthetic */ void access$setTouchUtils$p(FloatingWindowHelper $this, TouchUtils touchUtils) {
        $this.touchUtils = touchUtils;
    }

    public static final /* synthetic */ void access$setGravity(FloatingWindowHelper $this, View view) {
        $this.setGravity(view);
    }

    public static final /* synthetic */ void access$initEditText(FloatingWindowHelper $this) {
        $this.initEditText();
    }

    public static final /* synthetic */ void access$enterAnim(FloatingWindowHelper $this, View floatingView) {
        $this.enterAnim(floatingView);
    }
}

