/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.permission.rom;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.util.Log;
import com.lzf.easyfloat.permission.PermissionUtils;
import java.lang.reflect.Method;

public class MeizuUtils {
    private static final String TAG = "MeizuUtils";

    public static boolean checkFloatWindowPermission(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return MeizuUtils.checkOp(context, 24);
        }
        return true;
    }

    public static void applyPermission(Fragment fragment) {
        try {
            Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
            intent.putExtra("packageName", fragment.getActivity().getPackageName());
            intent.setFlags(0x10000000);
            fragment.startActivityForResult(intent, 199);
        }
        catch (Exception e) {
            try {
                Log.e((String)TAG, (String)("\u83b7\u53d6\u60ac\u6d6e\u7a97\u6743\u9650, \u6253\u5f00AppSecActivity\u5931\u8d25, " + Log.getStackTraceString((Throwable)e)));
                PermissionUtils.commonROMPermissionApplyInternal(fragment);
            }
            catch (Exception eFinal) {
                Log.e((String)TAG, (String)("\u83b7\u53d6\u60ac\u6d6e\u7a97\u6743\u9650\u5931\u8d25, \u901a\u7528\u83b7\u53d6\u65b9\u6cd5\u5931\u8d25, " + Log.getStackTraceString((Throwable)eFinal)));
            }
        }
    }

    @TargetApi(value=19)
    private static boolean checkOp(Context context, int op) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            try {
                Class<AppOpsManager> clazz = AppOpsManager.class;
                Method method = clazz.getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                return 0 == (Integer)method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        } else {
            Log.e((String)TAG, (String)"Below API 19 cannot invoke!");
        }
        return false;
    }
}

