/*
 * Decompiled with CFR 0.152.
 */
package com.github.premnirmal.textcounter;

import com.github.premnirmal.textcounter.CounterView;

class Counter
implements Runnable {
    final CounterView view;
    final float increment;
    final float startValue;
    final float endValue;
    final long interval;
    float currentValue;
    float newValue;

    Counter(CounterView view, float startValue, float endValue, long interval, float increment) {
        this.view = view;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interval = interval;
        this.increment = increment;
        this.newValue = this.startValue;
        this.currentValue = this.startValue - increment;
    }

    @Override
    public void run() {
        if (this.valuesAreCorrect()) {
            float valueToSet;
            if (this.increment > 0.0f) {
                valueToSet = this.newValue <= this.endValue ? this.newValue : this.endValue;
            } else if (this.increment < 0.0f) {
                valueToSet = this.newValue >= this.endValue ? this.newValue : this.endValue;
            } else {
                return;
            }
            this.view.setCurrentTextValue(valueToSet);
            this.currentValue = this.newValue;
            this.newValue += this.increment;
            this.view.removeCallbacks(this);
            this.view.postDelayed(this, this.interval);
        } else {
            this.view.setCurrentTextValue(this.endValue);
        }
    }

    private boolean valuesAreCorrect() {
        if (this.increment > 0.0f) {
            return this.newValue >= this.currentValue && this.newValue < this.endValue;
        }
        if (this.increment < 0.0f) {
            return this.newValue < this.currentValue && this.newValue > this.endValue;
        }
        return false;
    }
}

