/*
 * Decompiled with CFR 0.152.
 */
package com.github.prasanthj.hll;

import com.github.prasanthj.hll.HLLRegister;
import java.util.Arrays;

public class HLLDenseRegister
implements HLLRegister {
    private byte[] register;
    private int maxRegisterValue;
    private int numZeroes;
    private double[] invPow2Register;
    private int p;
    private int m;

    public HLLDenseRegister(int p) {
        this(p, true);
    }

    public HLLDenseRegister(int p, boolean bitPack) {
        this.p = p;
        this.m = 1 << p;
        this.register = new byte[this.m];
        this.invPow2Register = new double[this.m];
        Arrays.fill(this.invPow2Register, 1.0);
        this.maxRegisterValue = 0;
        this.numZeroes = this.m;
        if (!bitPack) {
            this.maxRegisterValue = 255;
        }
    }

    @Override
    public boolean add(long hashcode) {
        int registerIdx = (int)(hashcode & (long)(this.m - 1));
        long w = hashcode >>> this.p;
        int lr = Long.numberOfTrailingZeros(w) + 1;
        return this.set(registerIdx, (byte)lr);
    }

    @Override
    public boolean set(int idx, byte value) {
        boolean updated = false;
        if (idx < this.register.length && value > this.register[idx]) {
            if (value > this.maxRegisterValue) {
                this.maxRegisterValue = value;
            }
            if (this.register[idx] == 0 && value > 0) {
                --this.numZeroes;
            }
            this.register[idx] = value;
            this.invPow2Register[idx] = Math.pow(2.0, -value);
            updated = true;
        }
        return updated;
    }

    public int size() {
        return this.register.length;
    }

    public int getNumZeroes() {
        return this.numZeroes;
    }

    @Override
    public void merge(HLLRegister hllRegister) {
        if (hllRegister instanceof HLLDenseRegister) {
            HLLDenseRegister hdr = (HLLDenseRegister)hllRegister;
            byte[] inRegister = hdr.getRegister();
            if (this.register.length != inRegister.length) {
                throw new IllegalArgumentException("The size of register sets of HyperLogLogs to be merged does not match.");
            }
            for (int i = 0; i < inRegister.length; ++i) {
                if (inRegister[i] <= this.register[i]) continue;
                if (this.register[i] == 0) {
                    --this.numZeroes;
                }
                this.register[i] = inRegister[i];
                this.invPow2Register[i] = Math.pow(2.0, -inRegister[i]);
            }
            if (hdr.getMaxRegisterValue() > this.maxRegisterValue) {
                this.maxRegisterValue = hdr.getMaxRegisterValue();
            }
        } else {
            throw new IllegalArgumentException("Specified register is not instance of HLLDenseRegister");
        }
    }

    public byte[] getRegister() {
        return this.register;
    }

    public void setRegister(byte[] register) {
        this.register = register;
    }

    public int getMaxRegisterValue() {
        return this.maxRegisterValue;
    }

    public double getSumInversePow2() {
        double sum = 0.0;
        for (double d : this.invPow2Register) {
            sum += d;
        }
        return sum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HLLDenseRegister - ");
        sb.append("p: ");
        sb.append(this.p);
        sb.append(" numZeroes: ");
        sb.append(this.numZeroes);
        sb.append(" maxRegisterValue: ");
        sb.append(this.maxRegisterValue);
        return sb.toString();
    }

    public String toExtendedString() {
        return this.toString() + " register: " + Arrays.toString(this.register);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HLLDenseRegister)) {
            return false;
        }
        HLLDenseRegister other = (HLLDenseRegister)obj;
        return this.numZeroes == other.numZeroes && this.maxRegisterValue == other.maxRegisterValue && Arrays.equals(this.register, other.register);
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode += 31 * this.numZeroes;
        hashcode += 31 * this.maxRegisterValue;
        return hashcode += Arrays.hashCode(this.register);
    }
}

