/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.smartcropperlib;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import java.io.IOException;
import me.pqpo.smartcropperlib.ImageDetector;
import me.pqpo.smartcropperlib.utils.CropUtils;

public class SmartCropper {
    private static ImageDetector sImageDetector = null;

    public static void buildImageDetector(Context context) {
        SmartCropper.buildImageDetector(context, null);
    }

    public static void buildImageDetector(Context context, String modelFile) {
        try {
            sImageDetector = new ImageDetector(context, modelFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Point[] scan(Bitmap srcBmp) {
        Bitmap bitmap;
        if (srcBmp == null) {
            throw new IllegalArgumentException("srcBmp cannot be null");
        }
        if (sImageDetector != null && (bitmap = sImageDetector.detectImage(srcBmp)) != null) {
            srcBmp = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)srcBmp.getWidth(), (int)srcBmp.getHeight(), (boolean)false);
        }
        Point[] outPoints = new Point[4];
        SmartCropper.nativeScan(srcBmp, outPoints, sImageDetector == null);
        return outPoints;
    }

    public static Bitmap crop(Bitmap srcBmp, Point[] cropPoints) {
        if (srcBmp == null || cropPoints == null) {
            throw new IllegalArgumentException("srcBmp and cropPoints cannot be null");
        }
        if (cropPoints.length != 4) {
            throw new IllegalArgumentException("The length of cropPoints must be 4 , and sort by leftTop, rightTop, rightBottom, leftBottom");
        }
        Point leftTop = cropPoints[0];
        Point rightTop = cropPoints[1];
        Point rightBottom = cropPoints[2];
        Point leftBottom = cropPoints[3];
        int cropWidth = (int)((CropUtils.getPointsDistance(leftTop, rightTop) + CropUtils.getPointsDistance(leftBottom, rightBottom)) / 2.0);
        int cropHeight = (int)((CropUtils.getPointsDistance(leftTop, leftBottom) + CropUtils.getPointsDistance(rightTop, rightBottom)) / 2.0);
        Bitmap cropBitmap = Bitmap.createBitmap((int)cropWidth, (int)cropHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        SmartCropper.nativeCrop(srcBmp, cropPoints, cropBitmap);
        return cropBitmap;
    }

    private static native void nativeScan(Bitmap var0, Point[] var1, boolean var2);

    private static native void nativeCrop(Bitmap var0, Point[] var1, Bitmap var2);

    static {
        System.loadLibrary("smart_cropper");
    }
}

