/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.smartcropperlib;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.text.TextUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.tensorflow.lite.Interpreter;

public class ImageDetector {
    private static final String MODEL_FILE = "models/hed_lite_model_quantize.tflite";
    private int desiredSize = 256;
    private int[] intValues = new int[this.desiredSize * this.desiredSize];
    protected ByteBuffer imgData = null;
    protected ByteBuffer outImgData = null;
    protected Interpreter tflite;

    public ImageDetector(Context context) throws IOException {
        this(context, MODEL_FILE);
    }

    public ImageDetector(Context context, String modelFile) throws IOException {
        if (TextUtils.isEmpty((CharSequence)modelFile)) {
            modelFile = MODEL_FILE;
        }
        MappedByteBuffer tfliteModel = this.loadModelFile(context, modelFile);
        Interpreter.Options tfliteOptions = new Interpreter.Options();
        this.tflite = new Interpreter((ByteBuffer)tfliteModel, tfliteOptions);
        this.imgData = ByteBuffer.allocateDirect(this.desiredSize * this.desiredSize * 3 * 32 / 8);
        this.imgData.order(ByteOrder.nativeOrder());
        this.outImgData = ByteBuffer.allocateDirect(this.desiredSize * this.desiredSize * 32 / 8);
        this.outImgData.order(ByteOrder.nativeOrder());
    }

    public synchronized Bitmap detectImage(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        this.imgData.clear();
        this.outImgData.clear();
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.desiredSize, (int)this.desiredSize, (boolean)false);
        this.convertBitmapToByteBuffer(bitmap);
        this.tflite.run((Object)this.imgData, (Object)this.outImgData);
        return this.convertOutputBufferToBitmap(this.outImgData);
    }

    private void convertBitmapToByteBuffer(Bitmap bitmap) {
        if (this.imgData == null) {
            return;
        }
        bitmap.getPixels(this.intValues, 0, this.desiredSize, 0, 0, this.desiredSize, this.desiredSize);
        this.imgData.rewind();
        int pixel = 0;
        for (int i = 0; i < this.desiredSize; ++i) {
            for (int j = 0; j < this.desiredSize; ++j) {
                int pixelValue = this.intValues[pixel++];
                this.imgData.putFloat(pixelValue >> 16 & 0xFF);
                this.imgData.putFloat(pixelValue >> 8 & 0xFF);
                this.imgData.putFloat(pixelValue & 0xFF);
            }
        }
    }

    private Bitmap convertOutputBufferToBitmap(ByteBuffer outImgData) {
        if (outImgData == null) {
            return null;
        }
        outImgData.rewind();
        Bitmap bitmap_out = Bitmap.createBitmap((int)this.desiredSize, (int)this.desiredSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int[] pixels = new int[this.desiredSize * this.desiredSize];
        for (int i = 0; i < this.desiredSize * this.desiredSize; ++i) {
            float val = outImgData.getFloat();
            pixels[i] = (double)val > 0.2 ? -1 : -16777216;
        }
        bitmap_out.setPixels(pixels, 0, this.desiredSize, 0, 0, this.desiredSize, this.desiredSize);
        return bitmap_out;
    }

    private MappedByteBuffer loadModelFile(Context activity, String modelFile) throws IOException {
        AssetFileDescriptor fileDescriptor = activity.getAssets().openFd(modelFile);
        FileInputStream inputStream = new FileInputStream(fileDescriptor.getFileDescriptor());
        FileChannel fileChannel = inputStream.getChannel();
        long startOffset = fileDescriptor.getStartOffset();
        long declaredLength = fileDescriptor.getDeclaredLength();
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
    }
}

