/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a;

import android.util.Log;
import me.pqpo.librarylog4a.Log4a;

public class LogBuffer {
    private static final String TAG = "LogBuffer";
    private long ptr = 0L;
    private String logPath;
    private String bufferPath;
    private int bufferSize;
    private boolean compress;

    public LogBuffer(String bufferPath, int capacity, String logPath, boolean compress) {
        this.bufferPath = bufferPath;
        this.bufferSize = capacity;
        this.logPath = logPath;
        this.compress = compress;
        try {
            this.ptr = LogBuffer.initNative(bufferPath, capacity, logPath, compress);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log4a.getStackTraceString(e));
        }
    }

    public boolean isCompress() {
        return this.compress;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String getBufferPath() {
        return this.bufferPath;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void write(String log) {
        if (this.ptr != 0L) {
            try {
                this.writeNative(this.ptr, log);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log4a.getStackTraceString(e));
            }
        }
    }

    public void flushAsync() {
        if (this.ptr != 0L) {
            try {
                this.flushAsyncNative(this.ptr);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log4a.getStackTraceString(e));
            }
        }
    }

    public void release() {
        if (this.ptr != 0L) {
            try {
                this.releaseNative(this.ptr);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log4a.getStackTraceString(e));
            }
            this.ptr = 0L;
        }
    }

    private static native long initNative(String var0, int var1, String var2, boolean var3);

    private native void writeNative(long var1, String var3);

    private native void flushAsyncNative(long var1);

    private native void releaseNative(long var1);

    static {
        System.loadLibrary("log4a-lib");
    }
}

