/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a.appender;

import java.util.ArrayList;
import java.util.List;
import me.pqpo.librarylog4a.LogData;
import me.pqpo.librarylog4a.appender.Appender;
import me.pqpo.librarylog4a.interceptor.Interceptor;
import me.pqpo.librarylog4a.interceptor.LevelInterceptor;

public abstract class AbsAppender
implements Appender {
    public static final int MAX_LENGTH_OF_SINGLE_MESSAGE = 4063;
    public int maxSingleLength = 4063;
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private LevelInterceptor levelInterceptor = new LevelInterceptor();

    public AbsAppender() {
        this.addInterceptor(this.levelInterceptor);
    }

    public void setLevel(int level) {
        this.levelInterceptor.setLevel(level);
    }

    public void addInterceptor(List<Interceptor> interceptors) {
        if (interceptors != null && !interceptors.isEmpty()) {
            this.interceptors.addAll(interceptors);
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor != null) {
            this.interceptors.add(interceptor);
        }
    }

    public void setMaxSingleLength(int maxSingleLength) {
        this.maxSingleLength = maxSingleLength;
    }

    @Override
    public void append(int logLevel, String tag, String msg) {
        LogData logData = LogData.obtain(logLevel, tag, msg);
        boolean intercepted = false;
        for (Interceptor interceptor : this.interceptors) {
            if (interceptor.intercept(logData)) continue;
            intercepted = true;
        }
        if (!intercepted) {
            this.appendInner(logData.logLevel, logData.tag, logData.msg);
        }
        logData.recycle();
    }

    private void appendInner(int logLevel, String tag, String msg) {
        if (msg.length() <= this.maxSingleLength) {
            this.doAppend(logLevel, tag, msg);
            return;
        }
        int msgLength = msg.length();
        int start = 0;
        int end = start + this.maxSingleLength;
        while (start < msgLength) {
            this.doAppend(logLevel, tag, msg.substring(start, end));
            start = end;
            end = Math.min(start + this.maxSingleLength, msgLength);
        }
    }

    protected abstract void doAppend(int var1, String var2, String var3);

    @Override
    public void flush() {
    }

    @Override
    public void release() {
    }
}

