/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import me.pqpo.librarylog4a.logger.AndroidLogger;
import me.pqpo.librarylog4a.logger.Logger;

public class Log4a {
    private static Logger sLoggerDelegate = new AndroidLogger();

    public static void setLogger(Logger logger) {
        sLoggerDelegate = logger;
    }

    public static Logger getLogger() {
        return sLoggerDelegate;
    }

    public static void v(String tag, String msg) {
        Log4a.println(2, tag, msg);
    }

    public static void d(String tag, String msg) {
        Log4a.println(3, tag, msg);
    }

    public static void i(String tag, String msg) {
        Log4a.println(4, tag, msg);
    }

    public static void w(String tag, String msg) {
        Log4a.println(5, tag, msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        Log4a.println(5, tag, msg + "\n" + Log4a.getStackTraceString(tr));
    }

    public static void w(String tag, Throwable tr) {
        Log4a.println(5, tag, Log4a.getStackTraceString(tr));
    }

    public static void e(String tag, String msg) {
        Log4a.println(6, tag, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Log4a.println(6, tag, msg + "\n" + Log4a.getStackTraceString(tr));
    }

    public static void e(String tag, Throwable tr) {
        Log4a.println(6, tag, Log4a.getStackTraceString(tr));
    }

    public static void println(int priority, String tag, String msg) {
        if (sLoggerDelegate != null) {
            sLoggerDelegate.println(priority, tag, msg);
        }
    }

    public static void flush() {
        if (sLoggerDelegate != null) {
            sLoggerDelegate.flush();
        }
    }

    public static void release() {
        if (sLoggerDelegate != null) {
            sLoggerDelegate.release();
        }
        sLoggerDelegate = null;
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

