/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a.logger;

import java.util.ArrayList;
import java.util.List;
import me.pqpo.librarylog4a.appender.Appender;
import me.pqpo.librarylog4a.logger.Logger;

public class AppenderLogger
implements Logger {
    private List<Appender> appenderList = new ArrayList<Appender>();

    protected AppenderLogger() {
    }

    public List<Appender> getAppenderList() {
        return this.appenderList;
    }

    public void addAppender(Appender appender) {
        if (appender != null) {
            this.appenderList.add(appender);
        }
    }

    @Override
    public void println(int priority, String tag, String msg) {
        if (this.appenderList == null) {
            return;
        }
        for (Appender appender : this.appenderList) {
            appender.append(priority, tag, msg);
        }
    }

    @Override
    public void flush() {
        for (Appender appender : this.appenderList) {
            appender.flush();
        }
    }

    @Override
    public void release() {
        for (Appender appender : this.appenderList) {
            appender.release();
        }
        this.appenderList.clear();
    }

    public static class Builder {
        private AppenderLogger logger = new AppenderLogger();

        public Builder addAppender(Appender appender) {
            this.logger.addAppender(appender);
            return this;
        }

        public AppenderLogger create() {
            return this.logger;
        }
    }
}

