/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a.appender;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.pqpo.librarylog4a.Level;
import me.pqpo.librarylog4a.LogBuffer;
import me.pqpo.librarylog4a.appender.AbsAppender;
import me.pqpo.librarylog4a.formatter.Formatter;
import me.pqpo.librarylog4a.interceptor.Interceptor;

public class FileAppender
extends AbsAppender {
    private LogBuffer logBuffer;
    private Formatter formatter;

    protected FileAppender(Builder builder) {
        this.logBuffer = new LogBuffer(builder.bufferFilePath, builder.bufferSize, builder.logFilePath, builder.compress);
        this.setMaxSingleLength(builder.bufferSize);
        this.setLevel(builder.level);
        this.addInterceptor(builder.interceptors);
        this.setFormatter(builder.formatter);
    }

    public String getBufferPath() {
        return this.logBuffer.getBufferPath();
    }

    public int getBufferSize() {
        return this.logBuffer.getBufferSize();
    }

    public String getLogPath() {
        return this.logBuffer.getLogPath();
    }

    public void changeLogPath(String logPath) {
        this.logBuffer.changeLogPath(logPath);
    }

    public void setFormatter(Formatter formatter) {
        if (formatter != null) {
            this.formatter = formatter;
        }
    }

    @Override
    protected void doAppend(int logLevel, String tag, String msg) {
        this.logBuffer.write(this.formatter.format(logLevel, tag, msg));
    }

    @Override
    public void flush() {
        super.flush();
        this.logBuffer.flushAsync();
    }

    @Override
    public void release() {
        super.release();
        this.logBuffer.release();
    }

    public static class Builder {
        private Context context;
        private String bufferFilePath;
        private String logFilePath;
        private int bufferSize = 4096;
        private int level = 2;
        private List<Interceptor> interceptors;
        private Formatter formatter;
        private boolean compress;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setBufferFilePath(String bufferFilePath) {
            this.bufferFilePath = bufferFilePath;
            return this;
        }

        public Builder setLogFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
            return this;
        }

        public Builder setLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<Interceptor>();
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder setFormatter(Formatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder setCompress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public FileAppender create() {
            if (this.logFilePath == null) {
                throw new IllegalArgumentException("logFilePath cannot be null");
            }
            if (this.bufferFilePath == null) {
                this.bufferFilePath = this.getDefaultBufferPath(this.context);
            }
            if (this.formatter == null) {
                this.formatter = new Formatter(){

                    @Override
                    public String format(int logLevel, String tag, String msg) {
                        return String.format("%s/%s: %s\n", Level.getShortLevelName(logLevel), tag, msg);
                    }
                };
            }
            return new FileAppender(this);
        }

        private String getDefaultBufferPath(Context context) {
            File bufferFile = Environment.getExternalStorageState().equals("mounted") && context.getExternalFilesDir("log4a") != null ? context.getExternalFilesDir("log4a") : new File(context.getFilesDir(), "log4a");
            if (bufferFile != null && !bufferFile.exists()) {
                bufferFile.mkdirs();
            }
            return new File(bufferFile, ".log4aCache").getAbsolutePath();
        }
    }
}

