/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.generic.LocaleConfig;
import org.apache.velocity.tools.generic.ValueParser;

@DefaultKey(value="breadcrumb")
@ValidScope(value={"request"})
public class BreadcrumbTool
extends LocaleConfig
implements Iterable<NavigationElement> {
    protected List<NavigationElement> navigationElements = null;
    protected HttpServletRequest request = null;

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected boolean customize(NavigationElement navElem, HttpServletRequest request) {
        return true;
    }

    protected String formatElementName(String elem) {
        return elem.replace('_', ' ').toLowerCase(this.getLocale());
    }

    protected void configure(ValueParser config) {
        if (this.request == null) {
            this.getLog().warn("cannot build breadcrumb: no provided request");
            return;
        }
        String encoding = Optional.ofNullable(this.request.getCharacterEncoding()).orElse("UTF-8");
        Object uri = this.request.getRequestURI();
        try {
            uri = URLDecoder.decode((String)uri, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            this.getLog().error("Cannot decode URI using encoding {}", (Object)encoding);
            return;
        }
        String ext = BreadcrumbTool.getExtension((String)uri);
        String index = "index." + ext;
        if ("/".equals(uri)) {
            uri = "/" + index;
        }
        String[] elements = ((String)uri).split("/");
        this.navigationElements = new ArrayList<NavigationElement>();
        StringBuilder builder = new StringBuilder();
        for (String elem : elements) {
            builder.append(elem);
            Object currentPath = builder.toString();
            if (index.equals(elem)) continue;
            if (elem.endsWith("." + ext)) {
                elem = elem.substring(0, elem.length() - (ext.length() + 1));
            } else {
                currentPath = (String)currentPath + "/" + index;
                if (elem.length() == 0) {
                    elem = "home";
                }
            }
            String name = builder.length() == 0 ? "home" : this.formatElementName(elem);
            NavigationElement navElem = new NavigationElement((String)currentPath, name);
            if (this.customize(navElem, this.request)) {
                this.navigationElements.add(navElem);
                Object obj = config.get(elem);
                if (obj != null && obj instanceof ValueParser) {
                    String queryParamName = null;
                    String queryParamValue = null;
                    ValueParser values = (ValueParser)obj;
                    String newName = values.getString("name");
                    if (newName != null) {
                        if (newName.startsWith("?")) {
                            queryParamName = newName.substring(1);
                            queryParamValue = this.request.getParameter(queryParamName);
                            if (queryParamValue != null) {
                                navElem.setName(queryParamValue);
                            }
                        } else {
                            navElem.setName(newName);
                        }
                    }
                    Object newURL = values.getString("url");
                    if (queryParamValue == null) {
                        if (newURL != null) {
                            navElem.setUrl((String)newURL);
                        }
                    } else {
                        if (newURL == null) {
                            newURL = navElem.getUrl();
                        }
                        newURL = (String)newURL + (((String)newURL).indexOf(63) == -1 ? (char)'?' : '&');
                        newURL = (String)newURL + queryParamName + "=" + queryParamValue;
                        navElem.setUrl((String)newURL);
                    }
                }
            }
            builder.append('/');
        }
    }

    @Override
    public Iterator<NavigationElement> iterator() {
        return this.navigationElements.iterator();
    }

    protected static String getExtension(String filename) {
        int index;
        if (filename == null) {
            return null;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = filename.lastIndexOf(47);
        int n = index = lastSeparator > extensionPos ? -1 : extensionPos;
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int len = this.navigationElements.size();
        for (int i = 0; i < len; ++i) {
            NavigationElement elem = this.navigationElements.get(i);
            if (i > 0) {
                builder.append("&nbsp;&gt;&nbsp;");
            }
            if (i < len - 1) {
                builder.append("<a href=\"").append(elem.getUrl()).append("\">");
            }
            builder.append(elem.getName());
            if (i >= len - 1) continue;
            builder.append("</a>");
        }
        return builder.toString();
    }

    public static class NavigationElement {
        private String url;
        private String name;

        public NavigationElement(String url, String name) {
            this.url = url;
            if (name.endsWith(".vhtml")) {
                name = name.substring(0, name.indexOf(".vhtml"));
            }
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

