/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.request.attribute.HasKeys;
import org.apache.tiles.request.collection.CollectionUtil;
import org.apache.tiles.request.collection.KeySet;
import org.apache.tiles.request.collection.MapEntry;

public class ReadOnlyEnumerationMap<V>
implements Map<String, V> {
    protected HasKeys<V> request;

    public ReadOnlyEnumerationMap(HasKeys<V> request) {
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getValue(CollectionUtil.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Object realValue = value;
        Enumeration<String> keysIt = this.request.getKeys();
        while (keysIt.hasMoreElements()) {
            if (!realValue.equals(this.request.getValue(keysIt.nextElement()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new ReadOnlyEnumerationMapEntrySet();
    }

    @Override
    public V get(Object key) {
        return this.request.getValue(CollectionUtil.key(key));
    }

    @Override
    public boolean isEmpty() {
        return !this.request.getKeys().hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.request);
    }

    @Override
    public V put(String key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return CollectionUtil.enumerationSize(this.request.getKeys());
    }

    @Override
    public Collection<V> values() {
        return new ReadOnlyEnumerationMapValuesCollection();
    }

    @Override
    public boolean equals(Object o) {
        HasKeys<V> otherRequest = ((ReadOnlyEnumerationMap)o).request;
        boolean retValue = true;
        HashSet<String> otherKeys = new HashSet<String>();
        Enumeration<String> attribs = otherRequest.getKeys();
        while (attribs.hasMoreElements()) {
            otherKeys.add(attribs.nextElement());
        }
        attribs = this.request.getKeys();
        while (attribs.hasMoreElements() && retValue) {
            String parameterName = attribs.nextElement();
            retValue = this.request.getValue(parameterName).equals(otherRequest.getValue(parameterName));
            otherKeys.remove(parameterName);
        }
        return retValue && otherKeys.isEmpty();
    }

    @Override
    public int hashCode() {
        int retValue = 0;
        Enumeration<String> attribs = this.request.getKeys();
        while (attribs.hasMoreElements()) {
            String parameterName = attribs.nextElement();
            V value = this.request.getValue(parameterName);
            retValue += parameterName.hashCode() ^ (value == null ? 0 : value.hashCode());
        }
        return retValue;
    }

    class ReadOnlyEnumerationMapEntrySet
    implements Set<Map.Entry<String, V>> {
        ReadOnlyEnumerationMapEntrySet() {
        }

        @Override
        public boolean add(Map.Entry<String, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.containsEntry((Map.Entry)o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Collection<?> realCollection = c;
            for (Map.Entry entry : realCollection) {
                if (this.containsEntry(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ReadOnlyEnumerationMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new ReadOnlyEnumerationMapEntrySetIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ReadOnlyEnumerationMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.toList().toArray(a);
        }

        protected boolean containsEntry(Map.Entry<String, V> entry) {
            Object storedValue = ReadOnlyEnumerationMap.this.request.getValue(CollectionUtil.key(entry.getKey()));
            return storedValue != null && storedValue.equals(entry.getValue());
        }

        private List<Map.Entry<String, V>> toList() {
            ArrayList entries = new ArrayList();
            Enumeration<String> names = ReadOnlyEnumerationMap.this.request.getKeys();
            while (names.hasMoreElements()) {
                entries.add(this.extractNextEntry(names));
            }
            return entries;
        }

        private MapEntry<String, V> extractNextEntry(Enumeration<String> names) {
            String name = names.nextElement();
            return new MapEntry(name, ReadOnlyEnumerationMap.this.request.getValue(name), false);
        }

        private class ReadOnlyEnumerationMapEntrySetIterator
        implements Iterator<Map.Entry<String, V>> {
            private Enumeration<String> namesEnumeration;

            private ReadOnlyEnumerationMapEntrySetIterator() {
                this.namesEnumeration = ReadOnlyEnumerationMap.this.request.getKeys();
            }

            @Override
            public boolean hasNext() {
                return this.namesEnumeration.hasMoreElements();
            }

            @Override
            public Map.Entry<String, V> next() {
                return ReadOnlyEnumerationMapEntrySet.this.extractNextEntry(this.namesEnumeration);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class ReadOnlyEnumerationMapValuesCollection
    implements Collection<V> {
        private ReadOnlyEnumerationMapValuesCollection() {
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return ReadOnlyEnumerationMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Collection<?> realCollection = c;
            ArrayList valueList = new ArrayList(realCollection);
            Enumeration<String> keysEnum = ReadOnlyEnumerationMap.this.request.getKeys();
            while (keysEnum.hasMoreElements()) {
                valueList.remove(ReadOnlyEnumerationMap.this.request.getValue(keysEnum.nextElement()));
                if (!valueList.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return ReadOnlyEnumerationMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ReadOnlyEnumerationMapValuesCollectionIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return ReadOnlyEnumerationMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.toList().toArray(a);
        }

        private List<V> toList() {
            ArrayList entries = new ArrayList();
            Enumeration<String> names = ReadOnlyEnumerationMap.this.request.getKeys();
            while (names.hasMoreElements()) {
                entries.add(ReadOnlyEnumerationMap.this.request.getValue(names.nextElement()));
            }
            return entries;
        }

        private class ReadOnlyEnumerationMapValuesCollectionIterator
        implements Iterator<V> {
            private Enumeration<String> namesEnumeration;

            private ReadOnlyEnumerationMapValuesCollectionIterator() {
                this.namesEnumeration = ReadOnlyEnumerationMap.this.request.getKeys();
            }

            @Override
            public boolean hasNext() {
                return this.namesEnumeration.hasMoreElements();
            }

            @Override
            public V next() {
                return ReadOnlyEnumerationMap.this.request.getValue(this.namesEnumeration.nextElement());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

