/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.PowViewHolder;
import com.powyin.scroll.adapter.RecycleViewHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MultipleListAdapter<T>
implements ListAdapter,
AdapterDelegate<T> {
    private final int ITYPE_Empty = 0;
    private final int ITYPE_ERROR = 1;
    private final int ITYPE_LOAD = 2;
    private final int ITYPE_HEAD = 3;
    private final int ITYPE_FOOT = 4;
    private PowViewHolder[] mHolderInstances;
    private Constructor<? extends PowViewHolder>[] mHolderConstructor;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    List<T> mDataList = new ArrayList<T>();
    private AdapterDelegate.LoadedStatus mLoadStatus;
    private String mLoadCompleteInfo = "\u6211\u662f\u6709\u5e95\u7ebf\u7684";
    private String mLoadErrorInfo = "\u52a0\u8f7d\u5931\u8d25";
    private AdapterDelegate.OnLoadMoreListener mOnLoadMoreListener;
    AdapterDelegate.OnItemClickListener<T> mOnItemClickListener;
    AdapterDelegate.OnItemLongClickListener<T> mOnItemLongClickListener;
    private IncludeTypeLoad mLoad;
    private View mSpaceView;
    private View mHeadView;
    private View mFootView;
    private boolean mSpaceEnable = false;
    boolean mHasHead = false;
    private boolean mHasFoot = false;
    private boolean mHasLoad = false;
    private final DataSetObservable mDataSetObservable = new DataSetObservable();

    @SafeVarargs
    public static <T> MultipleListAdapter<T> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleListAdapter<T>(activity, arrClass);
    }

    @SafeVarargs
    public MultipleListAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        int i;
        Class[] arrClass = new Class[viewHolderClass.length];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        this.mActivity = activity;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        this.mHolderConstructor = new Constructor[arrClass.length];
        for (i = 0; i < arrClass.length; ++i) {
            try {
                this.mHolderConstructor[i] = arrClass[i].getConstructor(Activity.class, ViewGroup.class);
                this.mHolderConstructor[i].setAccessible(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class typeClass = arrClass[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            if (genericClass instanceof Class) {
                this.mHolderGenericDataClass[i] = (Class)genericClass;
            } else if (genericClass instanceof ParameterizedType) {
                this.mHolderGenericDataClass[i] = (Class)((ParameterizedType)genericClass).getRawType();
            } else {
                throw new RuntimeException("get genericClass error");
            }
            try {
                this.mHolderInstances[i] = this.mHolderConstructor[i].newInstance(this.mActivity, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u5b9e\u73b0\uff08Activity\uff09\u5355\u4e00\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5  \u6216\u8005  " + e.getMessage());
            }
        }
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public int getCount() {
        return this.mSpaceEnable ? 1 : this.mDataList.size() + (this.mHasHead ? 1 : 0) + (this.mHasFoot ? 1 : 0) + (this.mHasLoad ? 1 : 0);
    }

    public Object getItem(int position) {
        if (this.mSpaceEnable) {
            return 0;
        }
        if (this.mHasHead) {
            if (position == 0) {
                return 3;
            }
            --position;
        }
        if (position < this.mDataList.size()) {
            return this.mDataList.get(position);
        }
        if (this.mHasFoot && (position -= this.mDataList.size()) == 0) {
            return 4;
        }
        return 2;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        IncludeTypeEmpty empty;
        int type = this.getItemViewType(position);
        if (convertView == null) {
            switch (type) {
                case 0: {
                    FrameLayout contain = this.getSpaceContain(parent);
                    empty = new IncludeTypeEmpty(contain);
                    empty.itemView.setTag((Object)empty);
                    convertView = empty.itemView;
                    break;
                }
                case 1: {
                    IncludeTypeError error = new IncludeTypeError(parent);
                    error.itemView.setTag((Object)error);
                    convertView = error.itemView;
                    break;
                }
                case 2: {
                    IncludeTypeLoad load = new IncludeTypeLoad(parent);
                    load.itemView.setTag((Object)load);
                    convertView = load.itemView;
                    break;
                }
                case 3: {
                    IncludeTypeHead head = new IncludeTypeHead(parent);
                    head.itemView.setTag((Object)head);
                    convertView = head.itemView;
                    break;
                }
                case 4: {
                    IncludeTypeFoot foot = new IncludeTypeFoot(parent);
                    foot.itemView.setTag((Object)foot);
                    convertView = foot.itemView;
                    break;
                }
                default: {
                    PowViewHolder holder;
                    try {
                        holder = this.mHolderConstructor[type - 5].newInstance(this.mActivity, parent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.getMessage());
                    }
                    holder.mItemView.setTag((Object)holder);
                    convertView = holder.mItemView;
                }
            }
        }
        switch (type) {
            case 0: {
                empty = (IncludeTypeEmpty)((Object)convertView.getTag());
                empty.loadView();
                break;
            }
            case 1: {
                position = this.mHasHead ? position - 1 : position;
                IncludeTypeError error = (IncludeTypeError)((Object)convertView.getTag());
                error.loadData(this.mDataList.get(position));
                break;
            }
            case 2: {
                IncludeTypeLoad load;
                this.mLoad = load = (IncludeTypeLoad)((Object)convertView.getTag());
                load.progressBar.ensureAnimation(false);
                load.ensureLoading();
                break;
            }
            case 3: {
                IncludeTypeHead head = (IncludeTypeHead)((Object)convertView.getTag());
                head.loadView();
                break;
            }
            case 4: {
                IncludeTypeFoot foot = (IncludeTypeFoot)((Object)convertView.getTag());
                foot.loadView();
                break;
            }
            default: {
                position = this.mHasHead ? position - 1 : position;
                Object itemData = position < this.mDataList.size() ? (Object)this.mDataList.get(position) : null;
                PowViewHolder powViewHolder = (PowViewHolder)convertView.getTag();
                powViewHolder.mData = itemData;
                powViewHolder.mMultipleListAdapter = this;
                if (this.mOnItemClickListener != null) {
                    powViewHolder.registerAutoItemClick();
                }
                if (this.mOnItemLongClickListener != null) {
                    powViewHolder.registerAutoItemLongClick();
                }
                powViewHolder.loadData(this, itemData, position);
            }
        }
        return convertView;
    }

    public long getItemId(int position) {
        if (this.mSpaceEnable) {
            return 0L;
        }
        if (this.mHasHead) {
            if (position == 0) {
                return 3L;
            }
            --position;
        }
        if (position < this.mDataList.size()) {
            T data = this.mDataList.get(position);
            return data == null ? 0L : (long)data.hashCode();
        }
        if (this.mHasFoot && (position -= this.mDataList.size()) == 0) {
            return 4L;
        }
        return 2L;
    }

    public int getItemViewType(int position) {
        if (this.mSpaceEnable) {
            return 0;
        }
        if (this.mHasHead) {
            if (position == 0) {
                return 3;
            }
            --position;
        }
        if (position < this.mDataList.size()) {
            for (int i = 0; i < this.mHolderInstances.length; ++i) {
                T itemData = this.mDataList.get(position);
                if (itemData == null || !this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass()) || !this.mHolderInstances[i].acceptData(itemData)) continue;
                return i + 5;
            }
            return 1;
        }
        position -= this.mDataList.size();
        if (this.mHasFoot) {
            if (position == 0) {
                return 4;
            }
            --position;
        }
        if (position == 0 && this.mHasLoad) {
            return 2;
        }
        throw new RuntimeException(" what happen ");
    }

    public int getViewTypeCount() {
        return this.mHolderConstructor.length + 5;
    }

    public boolean isEmpty() {
        return false;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public void notifyDataSetChanged() {
        this.mDataSetObservable.notifyChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public List<T> getDataList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(this.mDataList);
        return arrayList;
    }

    @Override
    public int getDataCount() {
        return this.mDataList.size();
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, T data) {
        if (data == null) {
            return;
        }
        this.mDataList.add(position, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, List<T> dataList) {
        if (dataList == null) {
            return;
        }
        this.mDataList.addAll(position, dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void addDataAtLast(List<T> dataList) {
        this.addDataAtLast(dataList, null, 0);
    }

    @Override
    public void addDataAtLast(final List<T> dataList, final AdapterDelegate.LoadedStatus status, int delayTime) {
        if (delayTime <= 0) {
            this.mDataList.addAll(this.mDataList.size(), dataList);
            this.notifyDataSetChanged();
            this.setLoadMoreStatus(status);
        } else {
            this.mActivity.getWindow().getDecorView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MultipleListAdapter.this.mDataList.addAll(MultipleListAdapter.this.mDataList.size(), dataList);
                    MultipleListAdapter.this.notifyDataSetChanged();
                    MultipleListAdapter.this.setLoadMoreStatus(status);
                }
            }, (long)delayTime);
        }
    }

    @Override
    public T removeData(int position) {
        T ret = this.mDataList.remove(position);
        this.notifyDataSetChanged();
        return ret;
    }

    @Override
    public void removeData(T data) {
        int index = this.mDataList.indexOf(data);
        if (index >= 0) {
            this.removeData(index);
        }
    }

    @Override
    public void clearData() {
        if (this.mDataList.size() != 0) {
            this.mDataList.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void enableLoadMore(boolean show) {
        if (this.mHasLoad != show) {
            this.mHasLoad = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setLoadMoreStatus(AdapterDelegate.LoadedStatus status) {
        if (status == null) {
            return;
        }
        switch (status) {
            case NO_MORE: {
                this.mLoadStatus = AdapterDelegate.LoadedStatus.NO_MORE;
            }
        }
        if (this.mLoad != null) {
            this.mLoad.progressBar.invalidate();
        }
    }

    @Override
    public void loadMore() {
    }

    @Override
    public void completeLoadMore() {
    }

    @Override
    public void setOnLoadMoreListener(AdapterDelegate.OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    @Override
    public void setOnItemClickListener(AdapterDelegate.OnItemClickListener<T> clickListener) {
        this.mOnItemClickListener = clickListener;
    }

    @Override
    public void setOnItemLongClickListener(AdapterDelegate.OnItemLongClickListener<T> longClickListener) {
        this.mOnItemLongClickListener = longClickListener;
    }

    @Override
    public void setHeadView(View view) {
        if (view == null) {
            return;
        }
        this.mHasHead = true;
        this.mHeadView = view;
        this.notifyDataSetChanged();
    }

    @Override
    public void removeHeadView() {
        if (!this.mHasHead) {
            return;
        }
        this.mHasHead = false;
        this.mHeadView = null;
        this.notifyDataSetChanged();
    }

    @Override
    public void setFootView(View view) {
        if (view == null) {
            return;
        }
        this.mHasFoot = true;
        this.mFootView = view;
        this.notifyDataSetChanged();
    }

    @Override
    public void removeFootView() {
        if (!this.mHasFoot) {
            return;
        }
        this.mHasFoot = false;
        this.mFootView = null;
        this.notifyDataSetChanged();
    }

    @Override
    public void enableEmptyView(boolean show) {
        if (this.mSpaceEnable != show) {
            this.mSpaceEnable = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setEmptyView(View view) {
        if (view == null) {
            return;
        }
        if (this.mSpaceView != view) {
            this.mSpaceView = view;
            this.notifyDataSetChanged();
        }
    }

    private FrameLayout getSpaceContain(ViewGroup viewGroup) {
        FrameLayout frameLayout = new FrameLayout(viewGroup.getContext()){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        };
        TextView textView = new TextView(viewGroup.getContext());
        textView.setText((CharSequence)"space");
        textView.setTextColor(-16777216);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    class LoadProgressBar
    extends View {
        boolean mAttached;
        ValueAnimator animator;
        Paint circlePaint;
        TextPaint textPaint;
        int canvasWei;
        int canvasHei;
        float canvasTextX;
        float canvasTextY;
        int ballCount;
        float divide;
        private long beginShowTime;

        public LoadProgressBar(Context context) {
            super(context);
            this.mAttached = false;
            this.ballCount = 10;
            this.beginShowTime = System.currentTimeMillis();
            this.circlePaint = new Paint();
            this.circlePaint.setColor(-1728053248);
            this.circlePaint.setStrokeWidth(4.0f);
            this.textPaint = new TextPaint();
            this.textPaint.setColor(-1728053248);
            float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
            int target = (int)(13.0f * fontScale + 0.5f);
            this.textPaint.setTextSize((float)target);
            this.textPaint.setAntiAlias(true);
            this.textPaint.setStrokeWidth(1.0f);
        }

        private void ensureAnimation(boolean forceReStart) {
            if (!this.mAttached || MultipleListAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
                return;
            }
            if (forceReStart) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
            } else if (this.animator != null && this.animator.isRunning()) {
                return;
            }
            this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(2000L);
            this.animator.setRepeatCount(-1);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    LoadProgressBar.this.divide = (float)(8L * (System.currentTimeMillis() % 3000L - 1500L)) / 3000.0f;
                    LoadProgressBar.this.invalidate();
                }
            });
            this.animator.start();
        }

        private void ensureStopAnimation() {
            if (this.animator != null) {
                this.animator.cancel();
                this.animator = null;
            }
        }

        private float getSplit(float value) {
            int positive = value >= 0.0f ? 1 : -1;
            if ((value = Math.abs(value)) <= 1.0f) {
                return value * (float)positive;
            }
            return (float)Math.pow(value, 2.0) * (float)positive;
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mAttached = true;
            this.ensureAnimation(false);
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mAttached = false;
            this.ensureStopAnimation();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            float scale = this.getContext().getResources().getDisplayMetrics().density;
            int target = (int)(40.0f * scale + 0.5f);
            this.setMeasuredDimension(this.getMeasuredWidth(), target);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.beginShowTime == -1L) {
                return;
            }
            int timeBe = (int)(System.currentTimeMillis() - this.beginShowTime);
            float alpha = (float)timeBe / 2000.0f;
            alpha = alpha > 1.0f ? 1.0f : alpha;
            alpha = alpha < 0.0f ? 1.0f : alpha;
            int colorAlpha = (int)(alpha * 200.0f);
            this.textPaint.setAlpha(colorAlpha);
            this.circlePaint.setAlpha(colorAlpha);
            if (MultipleListAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE) {
                canvas.drawText(MultipleListAdapter.this.mLoadCompleteInfo, this.canvasTextX, this.canvasTextY, (Paint)this.textPaint);
                canvas.drawLine(20.0f, (float)(this.canvasHei / 2), this.canvasTextX - 20.0f, (float)(this.canvasHei / 2), (Paint)this.textPaint);
                canvas.drawLine((float)this.canvasWei - this.canvasTextX + 20.0f, (float)(this.canvasHei / 2), (float)(this.canvasWei - 20), (float)(this.canvasHei / 2), (Paint)this.textPaint);
            }
            if (MultipleListAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.ERROR) {
                canvas.drawText(MultipleListAdapter.this.mLoadErrorInfo, this.canvasTextX, this.canvasTextY, (Paint)this.textPaint);
                canvas.drawLine(20.0f, (float)(this.canvasHei / 2), this.canvasTextX - 20.0f, (float)(this.canvasHei / 2), (Paint)this.textPaint);
                canvas.drawLine((float)this.canvasWei - this.canvasTextX + 20.0f, (float)(this.canvasHei / 2), (float)(this.canvasWei - 20), (float)(this.canvasHei / 2), (Paint)this.textPaint);
            } else {
                for (int i = 0; i < this.ballCount; ++i) {
                    float wei = 4.0f * (1.0f * (float)i / (float)this.ballCount - 0.5f) + this.divide;
                    wei = (float)(this.canvasWei / 2) + this.getSplit(wei) * (float)this.canvasWei * 0.08f;
                    canvas.drawCircle(wei, (float)(this.canvasHei / 2 + 6), 8.0f, this.circlePaint);
                }
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            this.canvasHei = this.getHeight();
            this.canvasWei = this.getWidth();
            this.canvasTextX = (float)(this.canvasWei / 2) - this.textPaint.measureText(MultipleListAdapter.this.mLoadCompleteInfo) / 2.0f;
            this.canvasTextY = (float)(this.canvasHei / 2) + this.textPaint.getTextSize() / 2.55f;
            this.beginShowTime = bottom < ((ViewGroup)this.getParent()).getHeight() ? -1L : System.currentTimeMillis();
        }
    }

    private class IncludeTypeFoot
    extends RecycleViewHolder<Object> {
        FrameLayout frameLayout;

        IncludeTypeFoot(ViewGroup viewGroup) {
            super(MultipleListAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_foot, viewGroup, false), null);
            this.frameLayout = (FrameLayout)this.itemView;
        }

        void loadView() {
            if (MultipleListAdapter.this.mFootView != null) {
                ViewParent parent = MultipleListAdapter.this.mFootView.getParent();
                if (parent != null) {
                    ((ViewGroup)parent).removeView(MultipleListAdapter.this.mFootView);
                }
                this.frameLayout.removeAllViews();
                this.frameLayout.addView(MultipleListAdapter.this.mFootView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            }
        }
    }

    private class IncludeTypeHead
    extends RecycleViewHolder<Object> {
        FrameLayout frameLayout;

        IncludeTypeHead(ViewGroup viewGroup) {
            super(MultipleListAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_head, viewGroup, false), null);
            this.frameLayout = (FrameLayout)this.itemView;
        }

        void loadView() {
            if (MultipleListAdapter.this.mHeadView != null) {
                ViewParent parent = MultipleListAdapter.this.mHeadView.getParent();
                if (parent != null) {
                    ((ViewGroup)parent).removeView(MultipleListAdapter.this.mHeadView);
                }
                this.frameLayout.removeAllViews();
                this.frameLayout.addView(MultipleListAdapter.this.mHeadView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            }
        }
    }

    private class IncludeTypeLoad
    extends RecycleViewHolder<Object> {
        LoadProgressBar progressBar;

        IncludeTypeLoad(ViewGroup viewGroup) {
            super(new LoadProgressBar((Context)MultipleListAdapter.this.mActivity), null);
            this.progressBar = (LoadProgressBar)this.itemView;
        }

        void ensureLoading() {
            if (MultipleListAdapter.this.mLoadStatus == null && MultipleListAdapter.this.mOnLoadMoreListener != null) {
                MultipleListAdapter.this.mLoadStatus = null;
                MultipleListAdapter.this.mOnLoadMoreListener.onLoadMore();
            }
        }
    }

    private class IncludeTypeError
    extends RecycleViewHolder<Object> {
        TextView errorInfo;

        IncludeTypeError(ViewGroup viewGroup) {
            super(MultipleListAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_err, viewGroup, false), null);
            this.errorInfo = (TextView)this.itemView.findViewById(R.id.powyin_scroll_err_text);
        }

        private void loadData(T data) {
            this.errorInfo.setText((CharSequence)(data == null ? " you has one empty data inside " : data.toString()));
        }
    }

    private class IncludeTypeEmpty
    extends RecycleViewHolder<Object> {
        FrameLayout mainView;

        IncludeTypeEmpty(FrameLayout viewGroup) {
            super((View)viewGroup, null);
            this.mainView = viewGroup;
        }

        void loadView() {
            if (MultipleListAdapter.this.mSpaceView != null) {
                ViewParent parent = MultipleListAdapter.this.mSpaceView.getParent();
                if (parent != null) {
                    ((ViewGroup)parent).removeView(MultipleListAdapter.this.mSpaceView);
                }
                this.mainView.removeAllViews();
                this.mainView.addView(MultipleListAdapter.this.mSpaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
        }
    }
}

