/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.app.Activity;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.PowViewHolder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MultipleViewPageAdapter<T>
extends PagerAdapter
implements AdapterDelegate<T> {
    private PowViewHolder[] mHolderInstances;
    private Class<? extends PowViewHolder>[] mHolderClasses;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    List<T> mDataList = new ArrayList<T>();

    @SafeVarargs
    public static <T> MultipleViewPageAdapter<T> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleViewPageAdapter<T>(activity, arrClass);
    }

    @SafeVarargs
    public MultipleViewPageAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        Class[] arrClass = new Class[viewHolderClass.length];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        this.mActivity = activity;
        this.mHolderClasses = arrClass;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        for (int i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class<? extends PowViewHolder> typeClass = this.mHolderClasses[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            this.mHolderGenericDataClass[i] = (Class)genericClass;
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        T itemData = this.mDataList.get(position);
        PowViewHolder target = null;
        for (int i = 0; i < this.mHolderInstances.length; ++i) {
            if (itemData == null) {
                throw new RuntimeException("data must not be Null");
            }
            if (!this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass())) continue;
            if (this.mHolderInstances[i] == null) {
                try {
                    this.mHolderInstances[i] = this.mHolderClasses[i].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (!this.mHolderInstances[i].acceptData(itemData)) continue;
            target = this.mHolderInstances[i];
            this.mHolderInstances[i] = null;
            break;
        }
        if (target == null) {
            throw new RuntimeException("can not find holder to load the data");
        }
        container.addView(target.mItemView);
        target.loadData(null, itemData, position);
        target.onViewAttachedToWindow();
        return target;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        PowViewHolder target = (PowViewHolder)object;
        container.removeView(target.mItemView);
        target.onViewDetachedFromWindow();
        super.destroyItem(container, position, object);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        super.setPrimaryItem(container, position, object);
    }

    public float getPageWidth(int position) {
        return super.getPageWidth(position);
    }

    public int getCount() {
        return this.mDataList.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == ((PowViewHolder)object).mItemView;
    }

    @Override
    public List<T> getDataList() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.mDataList);
        return ret;
    }

    @Override
    public int getDataCount() {
        return this.mDataList.size();
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        if (this.mDataList != null && this.mDataList.size() > 0) {
            this.mDataList.addAll(dataList);
        }
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, T data) {
    }

    @Override
    public void addData(int position, List<T> dataList) {
    }

    @Override
    public void addDataAtLast(List<T> dataList) {
    }

    @Override
    public void addDataAtLast(List<T> dataList, AdapterDelegate.LoadedStatus status, int delayTime) {
    }

    @Override
    public T removeData(int position) {
        return null;
    }

    @Override
    public void removeData(T data) {
    }

    @Override
    public void clearData() {
    }

    @Override
    public void enableLoadMore(boolean enable) {
    }

    @Override
    public void setLoadMoreStatus(AdapterDelegate.LoadedStatus status) {
    }

    @Override
    public void setOnLoadMoreListener(AdapterDelegate.OnLoadMoreListener loadMoreListener) {
    }

    @Override
    public void setHeadView(View view) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setFootView(View view) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void removeHeadView() {
        throw new RuntimeException("not Support");
    }

    @Override
    public void removeFootView() {
        throw new RuntimeException("not Support");
    }

    @Override
    public void enableEmptyView(boolean show) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setEmptyView(View view) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setOnItemClickListener(AdapterDelegate.OnItemClickListener<T> clickListener) {
        throw new RuntimeException("not Support");
    }

    @Override
    public void setOnItemLongClickListener(AdapterDelegate.OnItemLongClickListener<T> clickListener) {
        throw new RuntimeException("not Support");
    }
}

