/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.MultipleRecycleAdapter;
import com.powyin.scroll.adapter.RecycleViewHolder;
import java.lang.reflect.Field;

public abstract class PowViewHolder<T> {
    final RecycleViewHolder<T> mViewHolder;
    protected final View mItemView;
    protected final Activity mActivity;
    protected T mData;
    protected AdapterDelegate<T> mMultipleAdapter;
    protected int mPosition;
    int mRegisterMainItemClickStatus = 0;
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (PowViewHolder.this.mMultipleAdapter != null && PowViewHolder.this.mMultipleAdapter instanceof MultipleRecycleAdapter) {
                MultipleRecycleAdapter adapter = (MultipleRecycleAdapter)PowViewHolder.this.mMultipleAdapter;
                adapter.invokeItemClick(PowViewHolder.this, PowViewHolder.this.mPosition, v.getId());
            }
        }
    };

    public PowViewHolder(Activity activity, ViewGroup viewGroup) {
        this.mActivity = activity;
        View item = this.getItemView();
        if (item == null && this.getItemViewRes() == 0) {
            throw new RuntimeException("must provide View by getItemView() or gitItemViewRes()");
        }
        this.mItemView = item == null ? activity.getLayoutInflater().inflate(this.getItemViewRes(), viewGroup, false) : item;
        this.mViewHolder = new RecycleViewHolder(this.mItemView, this);
    }

    final void registerAutoItemClick() {
        if (this.getItemViewOnClickListener() == null) {
            this.mItemView.setOnClickListener(this.mOnClickListener);
            this.mRegisterMainItemClickStatus = 1;
        } else {
            this.mRegisterMainItemClickStatus = -1;
        }
    }

    private View.OnClickListener getItemViewOnClickListener() {
        if (this.mItemView.hasOnClickListeners()) {
            try {
                Field mListenerInfo = View.class.getDeclaredField("mListenerInfo");
                mListenerInfo.setAccessible(true);
                Object infoObject = mListenerInfo.get(this.mItemView);
                if (infoObject == null) {
                    return null;
                }
                Field clickListener = infoObject.getClass().getDeclaredField("mOnClickListener");
                Object onClickObject = clickListener.get(infoObject);
                if (onClickObject == null) {
                    return null;
                }
                if (onClickObject instanceof View.OnClickListener) {
                    return (View.OnClickListener)onClickObject;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected final void registerItemClick(int ... viewIds) {
        if (this.mRegisterMainItemClickStatus > 0 && this.mItemView.hasOnClickListeners() && this.getItemViewOnClickListener() == this.mOnClickListener) {
            this.mItemView.setOnClickListener(null);
        }
        this.mRegisterMainItemClickStatus = -1;
        for (int i = 0; viewIds != null && i < viewIds.length; ++i) {
            View item = this.mItemView.findViewById(viewIds[i]);
            if (item == null) continue;
            item.setOnClickListener(this.mOnClickListener);
        }
    }

    protected final void unRegisterItemClick(int ... viewIds) {
        for (int i = 0; viewIds != null && i < viewIds.length; ++i) {
            View item = this.mItemView.findViewById(viewIds[i]);
            if (item == null) continue;
            this.mItemView.findViewById(viewIds[i]).setOnClickListener(null);
        }
    }

    protected abstract int getItemViewRes();

    public abstract void loadData(AdapterDelegate<? super T> var1, T var2, int var3);

    protected View getItemView() {
        return null;
    }

    protected boolean acceptData(T data) {
        return true;
    }

    protected void onViewAttachedToWindow() {
    }

    protected void onViewDetachedFromWindow() {
    }

    protected boolean ennableDragAndDrop() {
        return false;
    }
}

