/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.CircleViewBac;
import com.powyin.scroll.widget.LoadProgressBar;
import com.powyin.scroll.widget.SwipeControl;

public class SwipeControlStyleNormal
implements SwipeControl {
    private Context mContent;
    private View headView;
    private View overHead;
    private CircleViewBac statusPre;
    private ImageView statusLoad;
    private ImageView statusRefreshSuccess;
    private ImageView statueRefreshErrorAutoHide;
    private ImageView statusRefreshErrorFixed;
    private TextView textInfo;
    private View footView;
    private LoadProgressBar loadProgressBar;
    private TextView textLoad;

    SwipeControlStyleNormal(Context context) {
        this.mContent = context;
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContent);
        this.headView = inflater.inflate(R.layout.powyin_scroll_style_normal_head_swipe, null);
        this.overHead = this.headView.findViewById(R.id.powyin_swipe_over_head);
        this.statusPre = (CircleViewBac)this.headView.findViewById(R.id.powyin_swipe_image_info);
        this.statusLoad = (ImageView)this.headView.findViewById(R.id.powyin_swipe_refresh);
        this.statusRefreshSuccess = (ImageView)this.headView.findViewById(R.id.powyin_swipe_ok);
        this.statueRefreshErrorAutoHide = (ImageView)this.headView.findViewById(R.id.powyin_swipe_error_auto_hide);
        this.statusRefreshErrorFixed = (ImageView)this.headView.findViewById(R.id.powyin_swipe_error_fixed);
        this.textInfo = (TextView)this.headView.findViewById(R.id.powyin_swipe_text_info);
        this.footView = inflater.inflate(R.layout.powyin_scroll_style_normal_loading_more, null);
        this.loadProgressBar = (LoadProgressBar)this.footView.findViewById(R.id.powyin_scroll_load_bar);
        this.textLoad = (TextView)this.footView.findViewById(R.id.powyin_scroll_load_more);
    }

    @Override
    public View getSwipeHead() {
        return this.headView;
    }

    @Override
    public View getSwipeFoot() {
        return this.footView;
    }

    @Override
    public int getOverScrollHei() {
        return this.overHead.getHeight();
    }

    @Override
    public void onSwipeStatue(SwipeControl.SwipeStatus status, int visibleHei, int wholeHei) {
        switch (status) {
            case SWIPE_HEAD_OVER: {
                this.statusPre.setVisibility(0);
                this.statusPre.setProgress(1.0f);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusRefreshSuccess.setVisibility(4);
                this.statueRefreshErrorAutoHide.setVisibility(4);
                this.statusRefreshErrorFixed.setVisibility(4);
                if (this.textInfo.getText().toString().equals("\u677e\u5f00\u5237\u65b0")) break;
                this.textInfo.setText((CharSequence)"\u677e\u5f00\u5237\u65b0");
                break;
            }
            case SWIPE_HEAD_TOAST: {
                this.statusPre.setVisibility(0);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusRefreshSuccess.setVisibility(4);
                this.statueRefreshErrorAutoHide.setVisibility(4);
                this.statusRefreshErrorFixed.setVisibility(4);
                float radio = 2.0f * ((float)(visibleHei - this.textInfo.getHeight()) - (float)this.statusPre.getHeight() / 1.35f) / (float)this.statusPre.getHeight();
                this.statusPre.setProgress(radio);
                if (this.textInfo.getText().toString().equals("\u4e0a\u62c9\u5237\u65b0")) break;
                this.textInfo.setText((CharSequence)"\u4e0a\u62c9\u5237\u65b0");
                break;
            }
            case SWIPE_HEAD_LOADING: {
                this.statusPre.setVisibility(4);
                if (this.statusLoad.getVisibility() != 0) {
                    this.statusLoad.setVisibility(0);
                    this.statusLoad.setAnimation(AnimationUtils.loadAnimation((Context)this.mContent, (int)R.anim.powyin_scroll_rotale));
                }
                this.statusRefreshSuccess.setVisibility(4);
                this.statueRefreshErrorAutoHide.setVisibility(4);
                this.statusRefreshErrorFixed.setVisibility(4);
                if (this.textInfo.getText().toString().equals("\u6b63\u5728\u62fc\u547d\u5237\u65b0\u4e2d")) break;
                this.textInfo.setText((CharSequence)"\u6b63\u5728\u62fc\u547d\u5237\u65b0\u4e2d");
                break;
            }
            case SWIPE_HEAD_COMPLETE_OK: {
                this.statusPre.setVisibility(4);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusRefreshSuccess.setVisibility(0);
                this.statueRefreshErrorAutoHide.setVisibility(4);
                this.statusRefreshErrorFixed.setVisibility(4);
                if (this.textInfo.getText().toString().equals("\u5237\u65b0\u6210\u529f")) break;
                this.textInfo.setText((CharSequence)"\u5237\u65b0\u6210\u529f");
                break;
            }
            case SWIPE_HEAD_COMPLETE_ERROR_AUTO_CANCEL: {
                this.statusPre.setVisibility(4);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusRefreshSuccess.setVisibility(4);
                this.statueRefreshErrorAutoHide.setVisibility(0);
                this.statusRefreshErrorFixed.setVisibility(4);
                if (this.textInfo.getText().toString().equals("\u5237\u65b0\u5931\u8d25")) break;
                this.textInfo.setText((CharSequence)"\u5237\u65b0\u5931\u8d25");
                break;
            }
            case SWIPE_HEAD_COMPLETE_ERROR_FIXED: {
                this.statusPre.setVisibility(4);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusRefreshSuccess.setVisibility(4);
                this.statueRefreshErrorAutoHide.setVisibility(4);
                this.statusRefreshErrorFixed.setVisibility(0);
                if (!this.textInfo.getText().toString().equals("\u5237\u65b0\u5931\u8d25")) {
                    this.textInfo.setText((CharSequence)"\u5237\u65b0\u5931\u8d25");
                }
            }
            case SWIPE_LOAD_LOADING: {
                this.loadProgressBar.setVisibility(0);
                this.loadProgressBar.ensureAnimation();
                this.textLoad.setVisibility(8);
                break;
            }
            case SWIPE_LOAD_NO_MORE: {
                this.loadProgressBar.setVisibility(8);
                this.textLoad.setVisibility(0);
                break;
            }
            case SWIPE_LOAD_ERROR: {
                this.loadProgressBar.setVisibility(8);
                this.textLoad.setVisibility(0);
            }
        }
    }
}

