/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Space;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.PowViewHolder;
import com.powyin.scroll.adapter.ViewUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MultipleRecycleAdapter<T>
extends RecyclerView.Adapter<PowViewHolder.RecycleViewHolder>
implements AdapterDelegate<T> {
    private PowViewHolder[] mHolderInstances;
    private Class<? extends PowViewHolder>[] mHolderClasses;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    private List<T> mDataList = new ArrayList<T>();
    private boolean mShowError = true;
    private RecyclerView mRecyclerView;
    private int mSpaceCount;
    private int mLoadMoreCount;
    private boolean mLoadEnableShow = false;
    private AdapterDelegate.LoadStatus mLoadStatus = AdapterDelegate.LoadStatus.CONTINUE;
    private LoadMorePowViewHolder loadMorePowViewHolder;
    private String mLoadCompleteInfo = "\u6211\u662f\u6709\u5e95\u7ebf\u7684";
    private AdapterDelegate.OnLoadMoreListener mOnLoadMoreListener;
    private AdapterDelegate.OnItemClickListener<T> mOnItemClickListener;

    @SafeVarargs
    public static <T, N extends T> MultipleRecycleAdapter<N> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleRecycleAdapter<T>(activity, arrClass);
    }

    @SafeVarargs
    public MultipleRecycleAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        Class[] arrClass = new Class[viewHolderClass.length];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        this.mActivity = activity;
        this.mHolderClasses = arrClass;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        for (int i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class<? extends PowViewHolder> typeClass = this.mHolderClasses[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            this.mHolderGenericDataClass[i] = (Class)genericClass;
            try {
                this.mHolderInstances[i] = this.mHolderClasses[i].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public PowViewHolder.RecycleViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PowViewHolder holder;
        if (viewType == this.mHolderClasses.length + 2) {
            if (this.loadMorePowViewHolder == null) {
                this.loadMorePowViewHolder = new LoadMorePowViewHolder();
            }
            return this.loadMorePowViewHolder.getNewInstance();
        }
        if (viewType == this.mHolderClasses.length + 1) {
            return new IncludeTypeEmpty(parent);
        }
        if (viewType == this.mHolderClasses.length) {
            return new IncludeTypeError(parent);
        }
        try {
            holder = this.mHolderClasses[viewType].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, parent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return holder.mViewHolder;
    }

    public void onBindViewHolder(PowViewHolder.RecycleViewHolder holder, int position) {
        Object itemData = position < this.mDataList.size() ? (Object)this.mDataList.get(position) : null;
        PowViewHolder powViewHolder = holder.mPowViewHolder;
        if (position >= this.mDataList.size()) {
            if (position >= this.mDataList.size() + this.mSpaceCount) {
                ((LoadMorePowViewHolder.LoadProgressBar)holder.itemView).mIndex = position - (this.mDataList.size() + this.mSpaceCount);
            }
            if (this.mLoadStatus == AdapterDelegate.LoadStatus.CONTINUE && this.mOnLoadMoreListener != null) {
                this.mLoadStatus = null;
                this.mOnLoadMoreListener.onLoadMore();
            }
        } else if (powViewHolder != null) {
            powViewHolder.mData = itemData;
            powViewHolder.mMultipleAdapter = this;
            powViewHolder.mPosition = position;
            System.out.println("-----------" + position);
            if (this.mOnItemClickListener != null && powViewHolder.mRegisterMainItemClickStatus == 0) {
                powViewHolder.registerAutoItemClick();
                System.out.println("-----------------gister---" + position);
            }
            powViewHolder.loadData(this, itemData, position);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    public int getItemCount() {
        this.ensureConfig();
        return this.mDataList.size() + this.mSpaceCount + this.mLoadMoreCount;
    }

    public void onViewAttachedToWindow(PowViewHolder.RecycleViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow();
    }

    public void onViewDetachedFromWindow(PowViewHolder.RecycleViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow();
    }

    public long getItemId(int position) {
        Object date = position < this.mDataList.size() ? (Object)this.mDataList.get(position) : null;
        return date == null ? 0L : (long)date.hashCode();
    }

    private void ensureConfig() {
        if (!this.mLoadEnableShow || this.mRecyclerView == null) {
            this.mSpaceCount = 0;
            this.mLoadMoreCount = 0;
        } else {
            RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                int spanCount = gridLayoutManager.getSpanCount();
                int dataSize = this.mDataList.size();
                this.mSpaceCount = dataSize % spanCount == 0 ? 0 : spanCount - dataSize % spanCount;
                this.mLoadMoreCount = spanCount;
            } else if (layoutManager instanceof LinearLayoutManager) {
                this.mSpaceCount = 0;
                this.mLoadMoreCount = 1;
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.mSpaceCount = 0;
                this.mLoadMoreCount = 1;
            } else {
                this.mSpaceCount = 0;
                this.mLoadMoreCount = 1;
            }
        }
    }

    public int getItemViewType(int position) {
        if (position >= this.mDataList.size()) {
            this.ensureConfig();
            if (position >= this.mDataList.size() + this.mSpaceCount) {
                return this.mHolderInstances.length + 2;
            }
            return this.mHolderInstances.length + 1;
        }
        for (int i = 0; i < this.mHolderInstances.length; ++i) {
            T itemData = this.mDataList.get(position);
            if (itemData == null || !this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass()) || !this.mHolderInstances[i].acceptData(itemData)) continue;
            return i;
        }
        return this.mHolderInstances.length;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRecyclerView = null;
    }

    final void invokeItemClick(PowViewHolder<T> powViewHolder, int index, int resId) {
        if (this.mOnItemClickListener != null && index >= 0 && index < this.mDataList.size()) {
            this.mOnItemClickListener.onClick(powViewHolder, this.mDataList.get(index), index, resId);
        }
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void deleteFirst() {
        this.mDataList.remove(0);
        this.notifyDataSetChanged();
    }

    @Override
    public void deleteLast() {
        this.mDataList.remove(this.mDataList.size() - 1);
        this.notifyDataSetChanged();
    }

    @Override
    public void addFirst(T data) {
        this.mDataList.add(0, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void addFirst(List<T> datas) {
        this.mDataList.addAll(0, datas);
        this.notifyDataSetChanged();
    }

    @Override
    public void addLast(T data) {
        if (data == null) {
            return;
        }
        this.mDataList.add(data);
        this.notifyDataSetChanged();
    }

    @Override
    public void addLast(final T data, final AdapterDelegate.LoadStatus status, int delayTime) {
        if (delayTime <= 10) {
            this.addLast(data);
            this.setLoadMoreStatus(status);
        } else {
            this.mActivity.getWindow().getDecorView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MultipleRecycleAdapter.this.addLast(data);
                    MultipleRecycleAdapter.this.setLoadMoreStatus(status);
                }
            }, (long)delayTime);
        }
    }

    @Override
    public void addLast(List<T> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        this.mDataList.addAll(this.mDataList.size(), dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void addLast(final List<T> dataList, final AdapterDelegate.LoadStatus status, int delayTime) {
        if (delayTime <= 10) {
            this.mDataList.addAll(this.mDataList.size(), dataList);
            this.setLoadMoreStatus(status);
        } else {
            this.mActivity.getWindow().getDecorView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MultipleRecycleAdapter.this.addLast(dataList);
                    MultipleRecycleAdapter.this.setLoadMoreStatus(status);
                }
            }, (long)delayTime);
        }
    }

    @Override
    public List<T> getDataList() {
        return this.mDataList;
    }

    @Override
    public void deleteData(T data) {
        if (this.mDataList.contains(data)) {
            this.mDataList.remove(data);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void deleteAllData() {
        if (this.mDataList.size() != 0) {
            this.mDataList.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setShowErrorHolder(boolean show) {
        if (this.mShowError != show) {
            this.mShowError = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setShowLoadMore(boolean show) {
        if (this.mLoadEnableShow != show) {
            this.mLoadEnableShow = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setLoadMoreStatus(AdapterDelegate.LoadStatus status) {
        if (status == null) {
            return;
        }
        switch (status) {
            case CONTINUE: {
                this.mLoadStatus = AdapterDelegate.LoadStatus.CONTINUE;
                break;
            }
            case COMPLITE: {
                this.mLoadStatus = AdapterDelegate.LoadStatus.COMPLITE;
            }
        }
        if (this.loadMorePowViewHolder != null) {
            this.loadMorePowViewHolder.ensureAnimation(false);
            for (RecyclerView.ViewHolder holder : this.loadMorePowViewHolder.viewHolders) {
                holder.itemView.invalidate();
            }
        }
    }

    @Override
    public void setOnLoadMoreListener(AdapterDelegate.OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    @Override
    public void setOnItemClickListener(AdapterDelegate.OnItemClickListener<T> clickListener) {
        this.mOnItemClickListener = clickListener;
    }

    private class LoadMorePowViewHolder {
        boolean mAttached = false;
        List<RecyclerView.ViewHolder> viewHolders = new ArrayList<RecyclerView.ViewHolder>();
        ValueAnimator animator;
        Paint circlePaint = new Paint();
        TextPaint textPaint;
        int canvasWei;
        int canvasHei;
        float canvasTextX;
        float canvasTextY;
        int ballCount = 10;
        float divide;

        LoadMorePowViewHolder() {
            this.circlePaint.setColor(-1728053248);
            this.circlePaint.setStrokeWidth(4.0f);
            this.textPaint = new TextPaint();
            this.textPaint.setColor(-1728053248);
            this.textPaint.setTextSize((float)ViewUtils.sp2px((Context)MultipleRecycleAdapter.this.mActivity, 13.0f));
            this.textPaint.setAntiAlias(true);
            this.textPaint.setStrokeWidth(1.0f);
        }

        PowViewHolder.RecycleViewHolder getNewInstance() {
            PowViewHolder.RecycleViewHolder holder = new PowViewHolder.RecycleViewHolder(new LoadProgressBar((Context)MultipleRecycleAdapter.this.mActivity), null);
            this.viewHolders.add(holder);
            return holder;
        }

        private void ensureAnimation(boolean forceReStart) {
            if (!this.mAttached || MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadStatus.COMPLITE) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
                return;
            }
            if (forceReStart) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
            } else if (this.animator != null && this.animator.isRunning()) {
                return;
            }
            this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(2000L);
            this.animator.setRepeatCount(5);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    LoadMorePowViewHolder.this.divide = (float)(8L * (System.currentTimeMillis() % 3000L - 1500L)) / 3000.0f;
                    for (RecyclerView.ViewHolder holder : LoadMorePowViewHolder.this.viewHolders) {
                        holder.itemView.invalidate();
                    }
                }
            });
            this.animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (animation == LoadMorePowViewHolder.this.animator) {
                        LoadMorePowViewHolder.this.ensureAnimation(true);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animator.start();
        }

        private float getSplit(float value) {
            int positive = value >= 0.0f ? 1 : -1;
            if ((value = Math.abs(value)) <= 1.0f) {
                return value * (float)positive;
            }
            return (float)Math.pow(value, 2.0) * (float)positive;
        }

        class LoadProgressBar
        extends View {
            int mIndex;

            public LoadProgressBar(Context context) {
                super(context);
            }

            protected void onAttachedToWindow() {
                super.onAttachedToWindow();
                LoadMorePowViewHolder.this.mAttached = true;
                LoadMorePowViewHolder.this.ensureAnimation(false);
            }

            protected void onDetachedFromWindow() {
                super.onDetachedFromWindow();
                LoadMorePowViewHolder.this.mAttached = false;
                LoadMorePowViewHolder.this.ensureAnimation(false);
            }

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                this.setMeasuredDimension(this.getMeasuredWidth(), ViewUtils.dip2px(this.getContext(), 40.0f));
            }

            protected void onDraw(Canvas canvas) {
                super.onDraw(canvas);
                if (MultipleRecycleAdapter.this.mLoadStatus == AdapterDelegate.LoadStatus.COMPLITE) {
                    int diff = this.mIndex * this.getWidth();
                    canvas.drawText(MultipleRecycleAdapter.this.mLoadCompleteInfo, LoadMorePowViewHolder.this.canvasTextX - (float)diff, LoadMorePowViewHolder.this.canvasTextY, (Paint)LoadMorePowViewHolder.this.textPaint);
                    canvas.drawLine((float)(20 - diff), (float)(LoadMorePowViewHolder.this.canvasHei / 2), LoadMorePowViewHolder.this.canvasTextX - 20.0f - (float)diff, (float)(LoadMorePowViewHolder.this.canvasHei / 2), (Paint)LoadMorePowViewHolder.this.textPaint);
                    canvas.drawLine((float)LoadMorePowViewHolder.this.canvasWei - LoadMorePowViewHolder.this.canvasTextX + 20.0f - (float)diff, (float)(LoadMorePowViewHolder.this.canvasHei / 2), (float)(LoadMorePowViewHolder.this.canvasWei - 20 - diff), (float)(LoadMorePowViewHolder.this.canvasHei / 2), (Paint)LoadMorePowViewHolder.this.textPaint);
                } else {
                    for (int i = 0; i < LoadMorePowViewHolder.this.ballCount; ++i) {
                        float wei = 4.0f * (1.0f * (float)i / (float)LoadMorePowViewHolder.this.ballCount - 0.5f) + LoadMorePowViewHolder.this.divide;
                        wei = (float)(LoadMorePowViewHolder.this.canvasWei / 2) + LoadMorePowViewHolder.this.getSplit(wei) * (float)LoadMorePowViewHolder.this.canvasWei * 0.08f;
                        canvas.drawCircle(wei -= (float)(this.mIndex * this.getWidth()), (float)(LoadMorePowViewHolder.this.canvasHei / 2), 8.0f, LoadMorePowViewHolder.this.circlePaint);
                    }
                }
            }

            protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
                super.onLayout(changed, left, top, right, bottom);
                LoadMorePowViewHolder.this.canvasHei = this.getHeight();
                LoadMorePowViewHolder.this.canvasWei = this.getWidth() * MultipleRecycleAdapter.this.mLoadMoreCount;
                LoadMorePowViewHolder.this.canvasTextX = (float)(LoadMorePowViewHolder.this.canvasWei / 2) - LoadMorePowViewHolder.this.textPaint.measureText(MultipleRecycleAdapter.this.mLoadCompleteInfo) / 2.0f;
                LoadMorePowViewHolder.this.canvasTextY = (float)(LoadMorePowViewHolder.this.canvasHei / 2) + LoadMorePowViewHolder.this.textPaint.getTextSize() / 2.55f;
                LoadMorePowViewHolder.this.ensureAnimation(false);
            }
        }
    }

    private class IncludeTypeError
    extends PowViewHolder.RecycleViewHolder<Object> {
        TextView errorInfo;

        IncludeTypeError(ViewGroup viewGroup) {
            super(MultipleRecycleAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_err, viewGroup, false), null);
            this.errorInfo = (TextView)this.itemView.findViewById(R.id.powyin_scroll_err_text);
        }
    }

    private class IncludeTypeEmpty
    extends PowViewHolder.RecycleViewHolder<Object> {
        IncludeTypeEmpty(ViewGroup viewGroup) {
            super((View)new Space((Context)MultipleRecycleAdapter.this.mActivity), null);
        }
    }
}

